/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.RrdDbWrapper;
import org.neo4j.server.database.WrappedDatabase;
import org.neo4j.server.rrd.JobScheduler;
import org.neo4j.server.rrd.RrdFactory;
import org.neo4j.server.rrd.Sampleable;
import org.neo4j.server.web.ServerInternalSettings;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;

public class RrdFactoryTest {
    private Config config;
    private Database db;
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Before
    public void setUp() throws IOException {
        String storeDir = this.directory.graphDbDir().getAbsolutePath();
        this.db = new WrappedDatabase((GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir));
        this.config = new Config();
    }

    @Test
    public void shouldTakeDirectoryLocationFromConfig() throws Exception {
        String rrdPath = this.directory.directory("rrd").getAbsolutePath();
        this.addProperty(Configurator.RRDB_LOCATION_PROPERTY_KEY, rrdPath);
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)factory.directoryUsed, (Matcher)CoreMatchers.is((Object)rrdPath));
    }

    @Test
    public void shouldMoveAwayInvalidRrdFile() throws IOException {
        File rrdDir = new File(this.directory.directory(), ServerInternalSettings.rrd_store.getDefaultValue());
        Assert.assertTrue((boolean)rrdDir.mkdirs());
        this.addProperty(Configurator.RRDB_LOCATION_PROPERTY_KEY, rrdDir.getAbsolutePath());
        TestableRrdFactory factory = this.createRrdFactory();
        this.createInvalidRrdFile(new File(rrdDir, "rrd").getAbsolutePath());
        RrdDbWrapper rrdDbAndSampler = factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        this.assertSubdirectoryExists("rrd-invalid", rrdDir);
        rrdDbAndSampler.close();
    }

    private void createInvalidRrdFile(String rrdFilePath) throws IOException {
        RrdDef rrdDef = new RrdDef(rrdFilePath, 3000L);
        rrdDef.addDatasource("test", DsType.GAUGE, 1L, Double.NaN, Double.NaN);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.2, 1, 1600);
        RrdDb r = new RrdDb(rrdDef);
        r.close();
    }

    @Test
    public void shouldCreateRrdFileInTheConfiguredDirectory() throws Exception {
        File rrdDir = new File(this.directory.directory(), ServerInternalSettings.rrd_store.getDefaultValue());
        Assert.assertTrue((boolean)rrdDir.mkdirs());
        String rrdFilePath = new File(rrdDir, "rrd").getAbsolutePath();
        this.addProperty(Configurator.RRDB_LOCATION_PROPERTY_KEY, rrdFilePath);
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)factory.directoryUsed, (Matcher)CoreMatchers.is((Object)rrdFilePath));
    }

    @Test
    public void shouldDeleteOldRrdFileFromDbDirectoryIfItExists() throws Exception {
        File rrdDir = new File(ServerInternalSettings.rrd_store.getDefaultValue()).getAbsoluteFile();
        FileUtils.deleteFile((File)rrdDir);
        FileUtils.deleteRecursively((File)rrdDir);
        File oldRrdFile = new File(this.directory.graphDbDir(), "rrd");
        Assert.assertTrue((boolean)oldRrdFile.createNewFile());
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertFalse((boolean)oldRrdFile.exists());
    }

    private void addProperty(String rrdbLocationPropertyKey, String expected) {
        Map params = this.config.getParams();
        params.put(rrdbLocationPropertyKey, expected);
        this.config.applyChanges(params);
    }

    private void assertSubdirectoryExists(String directoryThatShouldExist, File directoryUsed) {
        String[] list;
        for (String aList : list = directoryUsed.list()) {
            if (!aList.startsWith(directoryThatShouldExist)) continue;
            return;
        }
        Assert.fail((String)String.format("Didn't find [%s] in [%s]", directoryThatShouldExist, directoryUsed));
    }

    private TestableRrdFactory createRrdFactory() {
        return new TestableRrdFactory(this.config);
    }

    private static class NullJobScheduler
    implements JobScheduler {
        private NullJobScheduler() {
        }

        public void scheduleAtFixedRate(Runnable job, String name, long delay, long period) {
        }
    }

    private static class TestableRrdFactory
    extends RrdFactory {
        public String directoryUsed;

        public TestableRrdFactory(Config config) {
            super(config, (LogProvider)NullLogProvider.getInstance());
        }

        protected RrdDbWrapper createRrdb(File rrdFile, boolean ephemeral, Sampleable ... sampleables) {
            Assert.assertFalse((boolean)ephemeral);
            this.directoryUsed = rrdFile.getParent();
            return super.createRrdb(rrdFile, ephemeral, sampleables);
        }
    }
}

