/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class AuthorizationDisabledIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @Test
    public void shouldAllowDisablingAuthorization() throws Exception {
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.auth_enabled.name(), "false").build();
        this.server.start();
        HTTP.Response response = HTTP.POST(this.server.baseUri().resolve("db/data/node").toString(), HTTP.RawPayload.quotedJson("{'name':'My Node'}"));
        Assert.assertThat((Object)response.status(), (Matcher)Matchers.equalTo((Object)201));
        String node = response.location();
        Assert.assertThat((Object)HTTP.GET(node).status(), (Matcher)Matchers.equalTo((Object)200));
    }

    @After
    public void cleanup() {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

