/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.web.NoCacheHtmlFilter;

public class NoCacheHtmlFilterTest {
    @Test
    public void shouldAddCacheControlHeaderToHtmlResponses() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"index.html");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        new NoCacheHtmlFilter().doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("Cache-Control", "no-cache");
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Test
    public void shouldPassThroughRequestsForNonHtmlResources() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"index.js");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        new NoCacheHtmlFilter().doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        Mockito.verifyZeroInteractions((Object[])new Object[]{response});
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Test
    public void shouldPassThroughRequestsWithNullServletPath() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletPath()).thenReturn(null);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        new NoCacheHtmlFilter().doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        Mockito.verifyZeroInteractions((Object[])new Object[]{response});
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

