/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.driver;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import java.net.URI;
import java.time.Clock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.MetricsListener;
import org.neo4j.bolt.connection.RoutingContext;
import org.neo4j.bolt.connection.netty.NettyBoltConnectionProvider;
import org.neo4j.bolt.connection.pooled.PooledBoltConnectionProvider;
import org.neo4j.bolt.connection.routed.Rediscovery;
import org.neo4j.bolt.connection.values.ValueFactory;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltLoggingProvider;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.RoutingSettings;
import org.neo4j.driver.internal.boltlistener.BoltConnectionListener;
import org.neo4j.driver.internal.security.StaticAuthTokenManager;
import org.neo4j.driver.internal.value.BoltValueFactory;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.queryapi.driver.DriverToInternalLogProvider;

public final class LocalChannelDriverFactory
extends DriverFactory {
    public static final URI IGNORED_HTTP_DRIVER_URI = URI.create("bolt://http-driver.com:0");
    private final LocalAddress localAddress;
    private final InternalLogProvider internalLogProvider;

    public LocalChannelDriverFactory(LocalAddress localAddress, InternalLogProvider internalLogProvider) {
        this.localAddress = localAddress;
        this.internalLogProvider = internalLogProvider;
    }

    protected LocalAddress localAddress() {
        return this.localAddress;
    }

    public Driver createLocalDriver() {
        return super.newInstance(IGNORED_HTTP_DRIVER_URI, (AuthTokenManager)new StaticAuthTokenManager(AuthTokens.none()), null, Config.builder().withLogging((Logging)new DriverToInternalLogProvider(this.internalLogProvider)).withUserAgent("neo4j-query-api/v2").build());
    }

    protected BoltConnectionProvider createBoltConnectionProvider(URI uri, Config config, EventLoopGroup eventLoopGroup, RoutingSettings routingSettings, Supplier<Rediscovery> rediscoverySupplier, BoltConnectionListener boltConnectionListener, BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener, Clock clock) {
        BoltLoggingProvider loggingProvider = new BoltLoggingProvider(config.logging());
        Function<BoltServerAddress, BoltConnectionProvider> pooledBoltConnectionProviderSupplier = selectedAddress -> this.createPooledBoltConnectionProvider(config, eventLoopGroup, clock, (LoggingProvider)loggingProvider, boltConnectionListener, (BoltServerAddress)selectedAddress, boltAgent, userAgent, connectTimeoutMillis, metricsListener);
        return pooledBoltConnectionProviderSupplier.apply(address);
    }

    private BoltConnectionProvider createPooledBoltConnectionProvider(Config config, EventLoopGroup eventLoopGroup, Clock clock, LoggingProvider loggingProvider, BoltConnectionListener boltConnectionListener, BoltServerAddress address, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener) {
        BoltConnectionProvider nettyBoltConnectionProvider = this.createNettyBoltConnectionProvider(eventLoopGroup, clock, loggingProvider);
        nettyBoltConnectionProvider = BoltConnectionListener.listeningBoltConnectionProvider((BoltConnectionProvider)nettyBoltConnectionProvider, (BoltConnectionListener)boltConnectionListener);
        return new PooledBoltConnectionProvider(nettyBoltConnectionProvider, config.maxConnectionPoolSize(), config.connectionAcquisitionTimeoutMillis(), config.maxConnectionLifetimeMillis(), config.idleTimeBeforeConnectionTest(), clock, loggingProvider, metricsListener, address, RoutingContext.EMPTY, boltAgent, userAgent, connectTimeoutMillis);
    }

    private BoltConnectionProvider createNettyBoltConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, LoggingProvider loggingProvider) {
        return new NettyBoltConnectionProvider(eventLoopGroup, clock, this.getDomainNameResolver(), this.localAddress(), loggingProvider, (ValueFactory)BoltValueFactory.getInstance(), null);
    }
}

