/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.driver;

import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalIoHandler;
import io.netty.util.concurrent.Future;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.security.StaticAuthTokenManager;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.queryapi.driver.DriverToInternalLogProvider;

public final class LocalChannelDriverFactory
extends DriverFactory
implements AutoCloseable {
    public static final URI IGNORED_HTTP_DRIVER_URI = URI.create("queryapi://http-driver.com:0");
    private final LocalAddress localAddress;
    private final InternalLogProvider internalLogProvider;
    private final Config config;
    private final MultiThreadIoEventLoopGroup localGroup;

    public LocalChannelDriverFactory(LocalAddress localAddress, InternalLogProvider internalLogProvider, Config config) {
        this.localAddress = localAddress;
        this.internalLogProvider = internalLogProvider;
        this.config = config;
        this.localGroup = new MultiThreadIoEventLoopGroup(LocalIoHandler.newFactory());
    }

    protected LocalAddress localAddress() {
        return this.localAddress;
    }

    public Driver createLocalDriver() {
        return super.newInstance(IGNORED_HTTP_DRIVER_URI, (AuthTokenManager)new StaticAuthTokenManager(AuthTokens.none()), null, org.neo4j.driver.Config.builder().withLogging((Logging)new DriverToInternalLogProvider(this.internalLogProvider)).withUserAgent("neo4j-query-api/v2").build(), null, (ScheduledExecutorService)this.localGroup, null);
    }

    @Override
    public void close() throws Exception {
        Future workerTerminationFuture = this.localGroup.shutdownGracefully((long)((Integer)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_quiet_period)).intValue(), ((Duration)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_timeout)).toSeconds(), TimeUnit.SECONDS);
        boolean workerTerminationCompleted = workerTerminationFuture.awaitUninterruptibly(((Duration)this.config.get(BoltConnectorInternalSettings.thread_pool_shutdown_wait_time)).toSeconds(), TimeUnit.SECONDS);
        if (!workerTerminationCompleted) {
            InternalLog log = this.internalLogProvider.getLog(LocalChannelDriverFactory.class);
            log.warn("Termination of local driver factory worker event loop group has exceeded maximum permitted duration - Remaining jobs will be forcefully terminated");
        } else if (!workerTerminationFuture.isSuccess()) {
            InternalLog log = this.internalLogProvider.getLog(LocalChannelDriverFactory.class);
            log.warn("Termination of local driver factory worker event loop group has failed", workerTerminationFuture.cause());
        }
    }
}

