/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ManagementApiModule;
import org.neo4j.server.web.WebServer;

public class ManagementApiModuleTest {
    @Test
    public void shouldRegisterASingleUri() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        HashMap<String, String> params = new HashMap<String, String>();
        String managementPath = "/db/manage";
        params.put(ServerSettings.management_api_path.name(), managementPath);
        Config config = Config.defaults(params);
        Mockito.when((Object)neoServer.getConfig()).thenReturn((Object)config);
        ManagementApiModule module = new ManagementApiModule(webServer, config);
        module.start();
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSClasses(ArgumentMatchers.anyListOf(String.class), ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.any());
    }
}

