/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;

public class TransitionalTxManagementKernelTransactionTest {
    private GraphDatabaseFacade databaseFacade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
    private ThreadToStatementContextBridge contextBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
    private LoginContext loginContext = AnonymousContext.read();
    private Transaction.Type type = Transaction.Type.implicit;

    @Test
    public void reopenStartTransactionWithCustomTimeoutIfSpecified() {
        TransitionalTxManagementKernelTransaction managementKernelTransaction = new TransitionalTxManagementKernelTransaction(this.databaseFacade, this.type, this.loginContext, 10L, this.contextBridge);
        managementKernelTransaction.reopenAfterPeriodicCommit();
        ((GraphDatabaseFacade)Mockito.verify((Object)this.databaseFacade, (VerificationMode)Mockito.times((int)2))).beginTransaction(this.type, this.loginContext, 10L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void reopenStartDefaultTransactionIfTimeoutNotSpecified() {
        TransitionalTxManagementKernelTransaction managementKernelTransaction = new TransitionalTxManagementKernelTransaction(this.databaseFacade, this.type, this.loginContext, -1L, this.contextBridge);
        managementKernelTransaction.reopenAfterPeriodicCommit();
        ((GraphDatabaseFacade)Mockito.verify((Object)this.databaseFacade, (VerificationMode)Mockito.times((int)2))).beginTransaction(this.type, this.loginContext);
    }
}

