/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.web.ScriptExecutionMode;

public class ScriptExecutionModeTest {
    @Test
    public void unrestrictedConfiguration() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{ServerSettings.script_enabled.name(), "true", ServerSettings.script_sandboxing_enabled.name(), "false"}));
        Assert.assertThat((Object)ScriptExecutionMode.getConfiguredMode((Config)config), (Matcher)Matchers.is((Object)ScriptExecutionMode.UNRESTRICTED));
    }

    @Test
    public void sandboxedConfiguration() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{ServerSettings.script_enabled.name(), "true", ServerSettings.script_sandboxing_enabled.name(), "true"}));
        Assert.assertThat((Object)ScriptExecutionMode.getConfiguredMode((Config)config), (Matcher)Matchers.is((Object)ScriptExecutionMode.SANDBOXED));
    }

    @Test
    public void disabledConfiguration() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{ServerSettings.script_enabled.name(), "false", ServerSettings.script_sandboxing_enabled.name(), "true"}));
        Assert.assertThat((Object)ScriptExecutionMode.getConfiguredMode((Config)config), (Matcher)Matchers.is((Object)ScriptExecutionMode.DISABLED));
        config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{ServerSettings.script_enabled.name(), "false", ServerSettings.script_sandboxing_enabled.name(), "false"}));
        Assert.assertThat((Object)ScriptExecutionMode.getConfiguredMode((Config)config), (Matcher)Matchers.is((Object)ScriptExecutionMode.DISABLED));
        config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{ServerSettings.script_enabled.name(), "false"}));
        Assert.assertThat((Object)ScriptExecutionMode.getConfiguredMode((Config)config), (Matcher)Matchers.is((Object)ScriptExecutionMode.DISABLED));
    }
}

