/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.plugins.BadPluginInvocationException;
import org.neo4j.server.plugins.ParameterDescriptionConsumer;
import org.neo4j.server.plugins.ParameterList;
import org.neo4j.server.plugins.PluginInvocationFailureException;
import org.neo4j.server.plugins.PluginInvocator;
import org.neo4j.server.plugins.PluginLookupException;
import org.neo4j.server.plugins.PluginPoint;
import org.neo4j.server.plugins.PluginPointFactory;
import org.neo4j.server.plugins.PluginPointFactoryImpl;
import org.neo4j.server.plugins.ServerExtender;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.ExtensionPointRepresentation;
import org.neo4j.server.rest.repr.Representation;

public final class PluginManager
implements ExtensionInjector,
PluginInvocator {
    private final Map<String, ServerExtender> extensions = new HashMap<String, ServerExtender>();

    public PluginManager(Config serverConfig, LogProvider logProvider) {
        this(serverConfig, ServerPlugin.load(), logProvider);
    }

    PluginManager(Config serverConfig, Iterable<ServerPlugin> plugins, LogProvider logProvider) {
        HashMap<String, Pair> extensions = new HashMap<String, Pair>();
        Log log = logProvider.getLog(this.getClass());
        for (ServerPlugin plugin : plugins) {
            PluginPointFactoryImpl factory = new PluginPointFactoryImpl();
            ServerExtender extender = new ServerExtender((PluginPointFactory)factory);
            try {
                plugin.loadServerExtender(extender);
            }
            catch (Exception | LinkageError ex) {
                log.warn("Failed to load plugin [%s]: %s", new Object[]{plugin.toString(), ex.getMessage()});
                continue;
            }
            Pair old = extensions.put(plugin.name, Pair.of((Object)plugin, (Object)extender));
            if (old == null) continue;
            log.warn(String.format("Extension naming conflict \"%s\" between \"%s\" and \"%s\"", plugin.name, ((ServerPlugin)old.first()).getClass(), plugin.getClass()));
        }
        for (Pair extension : extensions.values()) {
            log.info(String.format("Loaded server plugin \"%s\"", ((ServerPlugin)extension.first()).name));
            for (PluginPoint point : ((ServerExtender)extension.other()).all()) {
                log.info(String.format("  %s.%s: %s", point.forType().getSimpleName(), point.name(), point.getDescription()));
            }
            this.extensions.put(((ServerPlugin)extension.first()).name, (ServerExtender)extension.other());
        }
    }

    public Map<String, List<String>> getExensionsFor(Class<?> type) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, ServerExtender> extension : this.extensions.entrySet()) {
            ArrayList<String> methods = new ArrayList<String>();
            for (PluginPoint method : extension.getValue().getExtensionsFor(type)) {
                methods.add(method.name());
            }
            if (methods.isEmpty()) continue;
            result.put(extension.getKey(), methods);
        }
        return result;
    }

    private PluginPoint extension(String name, Class<?> type, String method) throws PluginLookupException {
        ServerExtender extender = this.extensions.get(name);
        if (extender == null) {
            throw new PluginLookupException("No such ServerPlugin: \"" + name + "\"");
        }
        return extender.getExtensionPoint(type, method);
    }

    @Override
    public ExtensionPointRepresentation describe(String name, Class<?> type, String method) throws PluginLookupException {
        return this.describe(this.extension(name, type, method));
    }

    private ExtensionPointRepresentation describe(PluginPoint extension) {
        ExtensionPointRepresentation representation = new ExtensionPointRepresentation(extension.name(), extension.forType(), extension.getDescription());
        extension.describeParameters((ParameterDescriptionConsumer)representation);
        return representation;
    }

    @Override
    public List<ExtensionPointRepresentation> describeAll(String name) throws PluginLookupException {
        ServerExtender extender = this.extensions.get(name);
        if (extender == null) {
            throw new PluginLookupException("No such ServerPlugin: \"" + name + "\"");
        }
        ArrayList<ExtensionPointRepresentation> result = new ArrayList<ExtensionPointRepresentation>();
        for (PluginPoint plugin : extender.all()) {
            result.add(this.describe(plugin));
        }
        return result;
    }

    @Override
    public <T> Representation invoke(GraphDatabaseAPI graphDb, String name, Class<T> type, String method, T context, ParameterList params) throws PluginLookupException, BadInputException, PluginInvocationFailureException, BadPluginInvocationException {
        PluginPoint plugin = this.extension(name, type, method);
        try {
            return plugin.invoke(graphDb, context, params);
        }
        catch (BadPluginInvocationException | PluginInvocationFailureException | BadInputException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginInvocationFailureException((Throwable)e);
        }
    }

    @Override
    public Set<String> extensionNames() {
        return Collections.unmodifiableSet(this.extensions.keySet());
    }
}

