/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.preflight.PreflightTask;

public class PreFlightTasks {
    private final PreflightTask[] tasks;
    private final Log log;
    private PreflightTask failedTask;

    public PreFlightTasks(LogProvider logProvider, PreflightTask ... tasks) {
        this.tasks = tasks;
        this.log = logProvider.getLog(this.getClass());
    }

    public boolean run() {
        if (this.tasks == null || this.tasks.length < 1) {
            return true;
        }
        for (PreflightTask r : this.tasks) {
            if (r.run()) continue;
            this.log.error(r.getFailureMessage());
            this.failedTask = r;
            return false;
        }
        return true;
    }

    public PreflightTask failedTask() {
        return this.failedTask;
    }
}

