/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.neo4j.concurrent.DecayingFlags;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.logging.Log;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionTerminationHandle;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.transactional.error.TransactionLifecycleException;
import org.neo4j.server.rest.web.TransactionUriScheme;
import org.neo4j.server.web.HttpHeaderUtils;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

@Path(value="/transaction")
public class TransactionalService {
    private final TransactionFacade facade;
    private final UsageData usage;
    private final TransactionUriScheme uriScheme;
    private Log log;

    public TransactionalService(@Context TransactionFacade facade, @Context UriInfo uriInfo, @Context UsageData usage, @Context Log log) {
        this.facade = facade;
        this.usage = usage;
        this.uriScheme = new TransactionUriBuilder(uriInfo);
        this.log = log;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeStatementsInNewTransaction(InputStream input, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        ((DecayingFlags)this.usage.get(UsageDataKeys.features)).flag(UsageDataKeys.Features.http_tx_endpoint);
        LoginContext loginContext = AuthorizedRequestWrapper.getLoginContextFromHttpServletRequest(request);
        long customTransactionTimeout = HttpHeaderUtils.getTransactionTimeout(request, this.log);
        TransactionHandle transactionHandle = this.facade.newTransactionHandle(this.uriScheme, false, loginContext, customTransactionTimeout);
        return this.createdResponse(transactionHandle, this.executeStatements(input, transactionHandle, uriInfo.getBaseUri(), request));
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeStatements(@PathParam(value="id") long id, InputStream input, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.findTransactionHandle(id);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e, uriInfo.getBaseUri());
        }
        return this.okResponse(this.executeStatements(input, transactionHandle, uriInfo.getBaseUri(), request));
    }

    @POST
    @Path(value="/{id}/commit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response commitTransaction(@PathParam(value="id") long id, InputStream input, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.findTransactionHandle(id);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e, uriInfo.getBaseUri());
        }
        return this.okResponse(this.executeStatementsAndCommit(input, transactionHandle, uriInfo.getBaseUri(), request));
    }

    @POST
    @Path(value="/commit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response commitNewTransaction(InputStream input, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        LoginContext loginContext = AuthorizedRequestWrapper.getLoginContextFromHttpServletRequest(request);
        long customTransactionTimeout = HttpHeaderUtils.getTransactionTimeout(request, this.log);
        TransactionHandle transactionHandle = this.facade.newTransactionHandle(this.uriScheme, true, loginContext, customTransactionTimeout);
        StreamingOutput streamingResults = this.executeStatementsAndCommit(input, transactionHandle, uriInfo.getBaseUri(), request);
        return this.okResponse(streamingResults);
    }

    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public Response rollbackTransaction(@PathParam(value="id") long id, @Context UriInfo uriInfo) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.terminate(id);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e, uriInfo.getBaseUri());
        }
        return this.okResponse(this.rollback(transactionHandle, uriInfo.getBaseUri()));
    }

    private Response invalidTransaction(TransactionLifecycleException e, URI baseUri) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.serializeError(e.toNeo4jError(), baseUri)).build();
    }

    private Response createdResponse(TransactionHandle transactionHandle, StreamingOutput streamingResults) {
        return Response.created((URI)transactionHandle.uri()).entity((Object)streamingResults).build();
    }

    private Response okResponse(StreamingOutput streamingResults) {
        return Response.ok().entity((Object)streamingResults).build();
    }

    private StreamingOutput executeStatements(InputStream input, TransactionHandle transactionHandle, URI baseUri, HttpServletRequest request) {
        return output -> transactionHandle.execute(this.facade.deserializer(input), this.facade.serializer(output, baseUri), request);
    }

    private StreamingOutput executeStatementsAndCommit(InputStream input, TransactionHandle transactionHandle, URI baseUri, HttpServletRequest request) {
        return output -> {
            OutputStream wrappedOutput = transactionHandle.isImplicit() ? new InterruptingOutputStream(output, transactionHandle) : output;
            transactionHandle.commit(this.facade.deserializer(input), this.facade.serializer(wrappedOutput, baseUri), request);
        };
    }

    private StreamingOutput rollback(TransactionHandle transactionHandle, URI baseUri) {
        return output -> {
            if (transactionHandle != null) {
                transactionHandle.rollback(this.facade.serializer(output, baseUri));
            }
        };
    }

    private StreamingOutput serializeError(Neo4jError neo4jError, URI baseUri) {
        return output -> {
            ExecutionResultSerializer serializer = this.facade.serializer(output, baseUri);
            serializer.errors(Collections.singletonList(neo4jError));
            serializer.finish();
        };
    }

    private class InterruptingOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private final TransactionTerminationHandle terminationHandle;

        private InterruptingOutputStream(OutputStream delegate, TransactionTerminationHandle terminationHandle) {
            this.delegate = delegate;
            this.terminationHandle = terminationHandle;
        }

        @Override
        public void write(byte[] b) throws IOException {
            try {
                this.delegate.write(b);
            }
            catch (IOException e) {
                this.terminate();
                throw e;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.delegate.write(b, off, len);
            }
            catch (IOException e) {
                this.terminate();
                throw e;
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.delegate.flush();
            }
            catch (IOException e) {
                this.terminate();
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                this.terminate();
                throw e;
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.delegate.write(b);
            }
            catch (IOException e) {
                this.terminate();
                throw e;
            }
        }

        private void terminate() {
            this.terminationHandle.terminate();
        }
    }

    public static class TransactionUriBuilder
    implements TransactionUriScheme {
        private final UriInfo uriInfo;

        public TransactionUriBuilder(UriInfo uriInfo) {
            this.uriInfo = uriInfo;
        }

        @Override
        public URI txUri(long id) {
            return this.builder(id).build(new Object[0]);
        }

        @Override
        public URI txCommitUri(long id) {
            return this.builder(id).path("/commit").build(new Object[0]);
        }

        private UriBuilder builder(long id) {
            return this.uriInfo.getBaseUriBuilder().path(TransactionalService.class).path("/" + id);
        }
    }
}

