/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.scripting.javascript;

import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.domain.EvaluationException;
import org.neo4j.server.rest.web.ScriptExecutionMode;
import org.neo4j.server.scripting.ScriptExecutor;
import org.neo4j.server.scripting.javascript.GlobalJavascriptInitializer;

public class JavascriptExecutor
implements ScriptExecutor {
    private final Scriptable prototype;
    private final Script compiledScript;

    public JavascriptExecutor(String script) {
        Context cx = Context.enter();
        try {
            this.prototype = this.createPrototype(cx);
            this.compiledScript = cx.compileString(script, "Unknown", 0, null);
        }
        finally {
            Context.exit();
        }
    }

    private Scriptable createPrototype(Context cx) {
        ScriptableObject proto = cx.initStandardObjects();
        ImporterTopLevel topLevel = new ImporterTopLevel(cx);
        proto.setParentScope((Scriptable)topLevel);
        return proto;
    }

    @Override
    public Object execute(Map<String, Object> variables) throws EvaluationException {
        Context cx = Context.enter();
        try {
            Object object;
            Object out;
            Scriptable scope = cx.newObject(this.prototype);
            scope.setPrototype(this.prototype);
            if (variables != null) {
                for (String k : variables.keySet()) {
                    scope.put(k, scope, variables.get(k));
                }
            }
            if ((out = this.compiledScript.exec(cx, scope)) instanceof NativeJavaObject) {
                object = ((NativeJavaObject)out).unwrap();
                return object;
            }
            if (out instanceof Undefined) {
                object = null;
                return object;
            }
            object = out;
            return object;
        }
        catch (RhinoException e) {
            throw new EvaluationException("Failed to execute script, see nested exception.", e);
        }
        finally {
            Context.exit();
        }
    }

    public static class Factory
    implements ScriptExecutor.Factory {
        private final ScriptExecutionMode executionMode;

        public Factory(ScriptExecutionMode executionMode) {
            this.executionMode = executionMode;
            GlobalJavascriptInitializer.initialize(executionMode);
        }

        @Override
        public ScriptExecutor createExecutorForScript(String script) throws EvaluationException {
            if (this.executionMode == ScriptExecutionMode.DISABLED) {
                throw new EvaluationException("Script execution is DISABLED via the " + ServerSettings.script_enabled.name() + " setting.");
            }
            return new JavascriptExecutor(script);
        }
    }
}

