/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.eclipse.jetty.http.HttpHeader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.ssl.ClientAuth;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.InsecureTrustManager;

public class HttpHeadersIT
extends ExclusiveServerTestBase {
    private static final String HSTS_HEADER_VALUE = "max-age=31536000; includeSubDomains; preload";
    private SSLSocketFactory originalSslSocketFactory;
    private CommunityNeoServer server;

    @Before
    public void setUp() {
        this.originalSslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
    }

    @After
    public void tearDown() throws Exception {
        HttpsURLConnection.setDefaultSSLSocketFactory(this.originalSslSocketFactory);
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldNotSendJettyVersionWithHttpResponseHeaders() throws Exception {
        this.startServer();
        HttpHeadersIT.testNoJettyVersionInResponseHeaders(this.httpUri());
    }

    @Test
    public void shouldNotSendJettyVersionWithHttpsResponseHeaders() throws Exception {
        this.startServer();
        HttpHeadersIT.testNoJettyVersionInResponseHeaders(this.httpsUri());
    }

    @Test
    public void shouldNotSendHstsHeaderWithHttpResponse() throws Exception {
        this.startServer(HSTS_HEADER_VALUE);
        Assert.assertNull((Object)HttpHeadersIT.runRequestAndGetHstsHeaderValue(this.httpUri()));
    }

    @Test
    public void shouldSendHstsHeaderWithHttpsResponse() throws Exception {
        this.startServer(HSTS_HEADER_VALUE);
        Assert.assertEquals((Object)HSTS_HEADER_VALUE, (Object)HttpHeadersIT.runRequestAndGetHstsHeaderValue(this.httpsUri()));
    }

    @Test
    public void shouldNotSendHstsHeaderWithHttpsResponseWhenNotConfigured() throws Exception {
        this.startServer();
        Assert.assertNull((Object)HttpHeadersIT.runRequestAndGetHstsHeaderValue(this.httpsUri()));
    }

    private void startServer() throws Exception {
        this.startServer(null);
    }

    private void startServer(String hstsValue) throws Exception {
        this.server = this.buildServer(hstsValue);
        this.server.start();
    }

    private CommunityNeoServer buildServer(String hstsValue) throws Exception {
        SslPolicyConfig httpsSslPolicyConfig = new SslPolicyConfig("default");
        CommunityServerBuilder builder = CommunityServerBuilder.serverOnRandomPorts().withHttpsEnabled().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).withProperty("https.ssl_policy", "default").withProperty(httpsSslPolicyConfig.base_directory.name(), this.folder.directory("cert").getAbsolutePath()).withProperty(httpsSslPolicyConfig.allow_key_generation.name(), "true").withProperty(httpsSslPolicyConfig.client_auth.name(), ClientAuth.NONE.name()).withProperty(httpsSslPolicyConfig.ciphers.name(), HttpHeadersIT.getSupportedCipherInACommaSeparatedString());
        if (hstsValue != null) {
            builder.withProperty(ServerSettings.http_strict_transport_security.name(), hstsValue);
        }
        return builder.build();
    }

    private URI httpUri() {
        return this.server.baseUri();
    }

    private URI httpsUri() {
        return (URI)this.server.httpsUri().orElseThrow(IllegalStateException::new);
    }

    private static void testNoJettyVersionInResponseHeaders(URI baseUri) throws Exception {
        Map<String, List<String>> headers = HttpHeadersIT.runRequestAndGetHeaders(baseUri);
        Assert.assertNull(headers.get(HttpHeader.SERVER.asString()));
        for (List<String> values : headers.values()) {
            Assert.assertFalse((boolean)values.stream().anyMatch(value -> value.toLowerCase().contains("jetty")));
        }
    }

    private static String runRequestAndGetHstsHeaderValue(URI baseUri) throws Exception {
        return HttpHeadersIT.runRequestAndGetHeaderValue(baseUri, HttpHeader.STRICT_TRANSPORT_SECURITY.asString());
    }

    private static String runRequestAndGetHeaderValue(URI baseUri, String header) throws Exception {
        List<String> values = HttpHeadersIT.runRequestAndGetHeaderValues(baseUri, header);
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        throw new IllegalStateException("Unexpected number of " + HttpHeader.STRICT_TRANSPORT_SECURITY.asString() + " header values: " + values);
    }

    private static List<String> runRequestAndGetHeaderValues(URI baseUri, String header) throws Exception {
        return HttpHeadersIT.runRequestAndGetHeaders(baseUri).getOrDefault(header, Collections.emptyList());
    }

    private static Map<String, List<String>> runRequestAndGetHeaders(URI baseUri) throws Exception {
        URI uri = baseUri.resolve("db/data/transaction/commit");
        ClientRequest request = HttpHeadersIT.createClientRequest(uri);
        ClientResponse response = HttpHeadersIT.createClient().handle(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        return response.getHeaders();
    }

    private static ClientRequest createClientRequest(URI uri) {
        return ((ClientRequest.Builder)ClientRequest.create().header("Accept", (Object)"application/json")).build(uri, "POST");
    }

    private static Client createClient() throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLSv1.2");
        ctx.init(null, new TrustManager[]{new InsecureTrustManager()}, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        return Client.create();
    }

    private static String getSupportedCipherInACommaSeparatedString() throws Exception {
        SSLServerSocketFactory ssf = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        CharSequence[] defaultCiphers = ssf.getDefaultCipherSuites();
        return String.join((CharSequence)",", defaultCiphers);
    }
}

