/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.junit.Assert;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RequestData;
import org.neo4j.test.GraphDefinition;
import org.neo4j.test.TestData;

public class RESTRequestGenerator {
    private static final ClientRequest.Builder REQUEST_BUILDER = ClientRequest.create();
    private static final List<String> RESPONSE_HEADERS = Arrays.asList("Content-Type", "Location");
    private static final List<String> REQUEST_HEADERS = Arrays.asList("Content-Type", "Accept");
    public static final TestData.Producer<RESTRequestGenerator> PRODUCER = new TestData.Producer<RESTRequestGenerator>(){

        public RESTRequestGenerator create(GraphDefinition graph, String title, String documentation) {
            return new RESTRequestGenerator();
        }

        public void destroy(RESTRequestGenerator product, boolean successful) {
        }
    };
    private int expectedResponseStatus = -1;
    private MediaType expectedMediaType = MediaType.valueOf((String)"application/json; charset=UTF-8");
    private MediaType payloadMediaType = MediaType.APPLICATION_JSON_TYPE;
    private final List<Pair<String, Predicate<String>>> expectedHeaderFields = new ArrayList<Pair<String, Predicate<String>>>();
    private String payload;
    private final Map<String, String> addedRequestHeaders = new TreeMap<String, String>();

    private RESTRequestGenerator() {
    }

    public RESTRequestGenerator expectedStatus(int expectedResponseStatus) {
        this.expectedResponseStatus = expectedResponseStatus;
        return this;
    }

    public RESTRequestGenerator expectedStatus(ClientResponse.Status expectedStatus) {
        this.expectedResponseStatus = expectedStatus.getStatusCode();
        return this;
    }

    public RESTRequestGenerator expectedType(MediaType expectedMediaType) {
        this.expectedMediaType = expectedMediaType;
        return this;
    }

    public RESTRequestGenerator payloadType(MediaType payloadMediaType) {
        this.payloadMediaType = payloadMediaType;
        return this;
    }

    public RESTRequestGenerator withHeader(String key, String value) {
        this.addedRequestHeaders.put(key, value);
        return this;
    }

    public RESTRequestGenerator payload(String payload) {
        this.payload = payload;
        return this;
    }

    public RESTRequestGenerator expectedHeader(String expectedHeaderField) {
        this.expectedHeaderFields.add((Pair<String, Predicate<String>>)Pair.of((Object)expectedHeaderField, (Object)Predicates.notNull()));
        return this;
    }

    public RESTRequestGenerator expectedHeader(String expectedHeaderField, String expectedValue) {
        this.expectedHeaderFields.add((Pair<String, Predicate<String>>)Pair.of((Object)expectedHeaderField, Predicate.isEqual(expectedValue)));
        return this;
    }

    public ResponseEntity get(String uri) {
        return this.retrieveResponseFromRequest("GET", uri, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    public ResponseEntity post(String uri) {
        return this.retrieveResponseFromRequest("POST", uri, this.payload, this.payloadMediaType, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    public ResponseEntity put(String uri) {
        return this.retrieveResponseFromRequest("PUT", uri, this.payload, this.payloadMediaType, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    public ResponseEntity delete(String uri) {
        return this.retrieveResponseFromRequest("DELETE", uri, this.payload, this.payloadMediaType, this.expectedResponseStatus, this.expectedMediaType, this.expectedHeaderFields);
    }

    private ResponseEntity retrieveResponseFromRequest(String method, String uri, int responseCode, MediaType accept, List<Pair<String, Predicate<String>>> headerFields) {
        ClientRequest request;
        try {
            request = ((ClientRequest.Builder)this.withHeaders(REQUEST_BUILDER).accept(new MediaType[]{accept})).build(new URI(uri), method);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this.retrieveResponse(uri, responseCode, accept, headerFields, request);
    }

    private ResponseEntity retrieveResponseFromRequest(String method, String uri, String payload, MediaType payloadType, int responseCode, MediaType accept, List<Pair<String, Predicate<String>>> headerFields) {
        ClientRequest request;
        try {
            request = payload != null ? ((ClientRequest.Builder)((ClientRequest.Builder)((ClientRequest.Builder)this.withHeaders(REQUEST_BUILDER).type(payloadType)).accept(new MediaType[]{accept})).entity((Object)payload)).build(new URI(uri), method) : ((ClientRequest.Builder)this.withHeaders(REQUEST_BUILDER).accept(new MediaType[]{accept})).build(new URI(uri), method);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this.retrieveResponse(uri, responseCode, accept, headerFields, request);
    }

    private <T extends ClientRequest.Builder> T withHeaders(T builder) {
        for (Map.Entry<String, String> entry : this.addedRequestHeaders.entrySet()) {
            builder.header(entry.getKey(), (Object)entry.getValue());
        }
        return builder;
    }

    private ResponseEntity retrieveResponse(String uri, int responseCode, MediaType type, List<Pair<String, Predicate<String>>> headerFields, ClientRequest request) {
        Client client;
        ClientResponse response;
        RequestData data = new RequestData();
        this.getRequestHeaders(data, (MultivaluedMap<String, Object>)request.getHeaders());
        if (request.getEntity() != null) {
            data.setPayload(String.valueOf(request.getEntity()));
        }
        if ((response = (client = new Client()).handle(request)).hasEntity() && response.getStatus() != 204) {
            data.setEntity((String)response.getEntity(String.class));
        }
        if (response.getType() != null) {
            Assert.assertTrue((String)("wrong response type: " + data.entity), (boolean)response.getType().isCompatible(type));
        }
        for (Pair<String, Predicate<String>> headerField : headerFields) {
            Assert.assertTrue((String)("wrong headers: " + response.getHeaders()), (boolean)((Predicate)headerField.other()).test(response.getHeaders().getFirst(headerField.first())));
        }
        data.setMethod(request.getMethod());
        data.setUri(uri);
        data.setStatus(responseCode);
        Assert.assertEquals((String)("Wrong response status. response: " + data.entity), (long)responseCode, (long)response.getStatus());
        this.getResponseHeaders(data, (MultivaluedMap<String, String>)response.getHeaders(), this.headerNames(headerFields));
        return new ResponseEntity(response, data.entity);
    }

    private List<String> headerNames(List<Pair<String, Predicate<String>>> headerPredicates) {
        ArrayList<String> names = new ArrayList<String>();
        for (Pair<String, Predicate<String>> headerPredicate : headerPredicates) {
            names.add((String)headerPredicate.first());
        }
        return names;
    }

    private void getResponseHeaders(RequestData data, MultivaluedMap<String, String> headers, List<String> additionalFilter) {
        data.setResponseHeaders(this.getHeaders(headers, RESPONSE_HEADERS, additionalFilter));
    }

    private void getRequestHeaders(RequestData data, MultivaluedMap<String, Object> headers) {
        data.setRequestHeaders(this.getHeaders(headers, REQUEST_HEADERS, this.addedRequestHeaders.keySet()));
    }

    private <T> Map<String, String> getHeaders(MultivaluedMap<String, T> headers, List<String> filter, Collection<String> additionalFilter) {
        TreeMap<String, String> filteredHeaders = new TreeMap<String, String>();
        for (Map.Entry header : headers.entrySet()) {
            String key = (String)header.getKey();
            if (!filter.contains(key) && !additionalFilter.contains(key)) continue;
            String values = "";
            for (Object value : (List)header.getValue()) {
                if (!values.isEmpty()) {
                    values = values + ", ";
                }
                values = values + String.valueOf(value);
            }
            filteredHeaders.put(key, values);
        }
        return filteredHeaders;
    }

    public static class ResponseEntity {
        private final String entity;
        private final JaxRsResponse response;

        public ResponseEntity(ClientResponse response, String entity) {
            this.response = new JaxRsResponse(response, entity);
            this.entity = entity;
        }

        public String entity() {
            return this.entity;
        }

        public JaxRsResponse response() {
            return this.response;
        }
    }
}

