/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.batch;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.rest.batch.BatchOperations;
import org.neo4j.server.rest.web.InternalJettyServletRequest;
import org.neo4j.server.rest.web.InternalJettyServletResponse;

public class BatchOperationsTest {
    private final BatchOperations ops = new BatchOperations(null){

        protected void invoke(String method, String path, String body, Integer id, URI targetUri, InternalJettyServletRequest req, InternalJettyServletResponse res) {
        }
    };

    @Test
    public void testReplaceLocations() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(100, "bar");
        Assert.assertEquals((Object)"foo", (Object)this.ops.replaceLocationPlaceholders("foo", map));
        Assert.assertEquals((Object)"foo bar", (Object)this.ops.replaceLocationPlaceholders("foo {100}", map));
        Assert.assertEquals((Object)"bar foo bar", (Object)this.ops.replaceLocationPlaceholders("{100} foo {100}", map));
        Assert.assertEquals((Object)"bar bar foo bar bar", (Object)this.ops.replaceLocationPlaceholders("bar {100} foo {100} bar", map));
    }

    @Test
    public void testSchemeInInternalJettyServletRequestForHttp() throws UnsupportedEncodingException {
        InternalJettyServletRequest req = new InternalJettyServletRequest("POST", "http://localhost:7473/db/data/node", "{'name':'node1'}", new InternalJettyServletResponse(), (InternalJettyServletRequest.RequestData)Mockito.mock(InternalJettyServletRequest.RequestData.class));
        Assert.assertEquals((Object)"http", (Object)req.getScheme());
    }

    @Test
    public void testSchemeInInternalJettyServletRequestForHttps() throws UnsupportedEncodingException {
        InternalJettyServletRequest req = new InternalJettyServletRequest("POST", "https://localhost:7473/db/data/node", "{'name':'node1'}", new InternalJettyServletResponse(), (InternalJettyServletRequest.RequestData)Mockito.mock(InternalJettyServletRequest.RequestData.class));
        Assert.assertEquals((Object)"https", (Object)req.getScheme());
    }

    @Test
    public void shouldForwardMetadataFromRequestData() throws Exception {
        InternalJettyServletRequest.RequestData mock = new InternalJettyServletRequest.RequestData("127.0.0.1", true, 1, "TheLocalName", "129.0.0.1", 2, "authorization/auth");
        InternalJettyServletRequest req = new InternalJettyServletRequest("POST", "https://localhost:7473/db/data/node", "", new InternalJettyServletResponse(), mock);
        Assert.assertEquals((Object)"127.0.0.1", (Object)req.getRemoteAddr());
        org.neo4j.test.assertion.Assert.assertException(() -> ((InternalJettyServletRequest)req).getRemoteHost(), UnsupportedOperationException.class, (String)"Remote host-name lookup might prove expensive, this should be explicitly considered.");
        Assert.assertTrue((boolean)req.isSecure());
        Assert.assertEquals((long)1L, (long)req.getRemotePort());
        Assert.assertEquals((Object)"TheLocalName", (Object)req.getLocalName());
        Assert.assertEquals((Object)"129.0.0.1", (Object)req.getLocalAddr());
        Assert.assertEquals((long)2L, (long)req.getLocalPort());
        Assert.assertEquals((Object)"authorization/auth", (Object)req.getAuthType());
    }

    @Test
    public void shouldIgnoreUnknownAndUnparseablePlaceholders() {
        Assert.assertEquals((Object)"foo {00000000010001010001001100111000100101010111001101110111}", (Object)this.ops.replaceLocationPlaceholders("foo {00000000010001010001001100111000100101010111001101110111}", Collections.emptyMap()));
        Assert.assertEquals((Object)"foo {2147483648}", (Object)this.ops.replaceLocationPlaceholders("foo {2147483648}", Collections.emptyMap()));
    }
}

