/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.rest.paging.HexMatcher;
import org.neo4j.server.rest.paging.Lease;
import org.neo4j.server.rest.paging.LeaseAlreadyExpiredException;
import org.neo4j.server.rest.paging.PagedTraverser;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class LeaseTest {
    private static final long SIXTY_SECONDS = 60L;

    @Test
    public void shouldReturnHexIdentifierString() {
        Lease lease = new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), 60L, (Clock)Clocks.fakeClock());
        Assert.assertThat((Object)lease.getId(), HexMatcher.containsOnlyHex());
    }

    @Test(expected=LeaseAlreadyExpiredException.class)
    public void shouldNotAllowLeasesInThePast() {
        FakeClock clock = Clocks.fakeClock();
        new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), this.oneMinuteInThePast(), (Clock)clock);
    }

    private long oneMinuteInThePast() {
        return -60L;
    }

    @Test
    public void leasesShouldExpire() {
        FakeClock clock = Clocks.fakeClock();
        Lease lease = new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), 60L, (Clock)clock);
        clock.forward(10L, TimeUnit.MINUTES);
        Assert.assertTrue((boolean)lease.expired());
    }

    @Test
    public void shouldRenewLeaseForSamePeriod() {
        FakeClock clock = Clocks.fakeClock();
        Lease lease = new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), 60L, (Clock)clock);
        clock.forward(30L, TimeUnit.SECONDS);
        lease.getLeasedItemAndRenewLease();
        clock.forward(30L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)lease.expired());
        clock.forward(10L, TimeUnit.MINUTES);
        Assert.assertTrue((boolean)lease.expired());
    }
}

