/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.PropertiesRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;

public class PropertiesRepresentationTest {
    @Test
    public void shouldContainAddedPropertiesWhenCreatedFromPropertyContainer() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("foo", "bar");
        Map<String, Object> serialized = RepresentationTestAccess.serialize((MappingRepresentation)new PropertiesRepresentation(PropertiesRepresentationTest.container(values)));
        Assert.assertEquals((Object)"bar", (Object)serialized.get("foo"));
    }

    @Test
    public void shouldSerializeToMapWithSamePropertiesWhenCreatedFromPropertyContainer() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("foo", "bar");
        PropertiesRepresentation properties = new PropertiesRepresentation(PropertiesRepresentationTest.container(values));
        Map<String, Object> map = RepresentationTestAccess.serialize((MappingRepresentation)properties);
        Assert.assertEquals(values, map);
    }

    @Test
    public void shouldSerializeToMap() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("string", "value");
        values.put("int", 5);
        values.put("long", 17L);
        values.put("double", 3.14);
        values.put("float", Float.valueOf(42.0f));
        values.put("string array", new String[]{"one", "two"});
        values.put("long array", new long[]{5L, 17L});
        values.put("double array", new double[]{3.14, 42.0});
        PropertiesRepresentation properties = new PropertiesRepresentation(PropertiesRepresentationTest.container(values));
        Map<String, Object> map = RepresentationTestAccess.serialize((MappingRepresentation)properties);
        Assert.assertEquals((Object)"value", (Object)map.get("string"));
        Assert.assertEquals((long)5L, (long)((Number)map.get("int")).longValue());
        Assert.assertEquals((long)17L, (long)((Number)map.get("long")).longValue());
        Assert.assertEquals((double)3.14, (double)((Number)map.get("double")).doubleValue(), (double)0.0);
        Assert.assertEquals((double)42.0, (double)((Number)map.get("float")).doubleValue(), (double)0.0);
        this.assertEqualContent(Arrays.asList("one", "two"), (List)map.get("string array"));
        this.assertEqualContent(Arrays.asList(5L, 17L), (List)map.get("long array"));
        this.assertEqualContent(Arrays.asList(3.14, 42.0), (List)map.get("double array"));
    }

    @Test
    public void shouldBeAbleToSignalEmptiness() {
        PropertiesRepresentation properties = new PropertiesRepresentation(PropertiesRepresentationTest.container(new HashMap<String, Object>()));
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("key", "value");
        Assert.assertTrue((boolean)properties.isEmpty());
        properties = new PropertiesRepresentation(PropertiesRepresentationTest.container(values));
        Assert.assertFalse((boolean)properties.isEmpty());
    }

    private void assertEqualContent(List<?> expected, List<?> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Iterator<?> ex = expected.iterator();
        Iterator<?> ac = actual.iterator();
        while (ex.hasNext() && ac.hasNext()) {
            Assert.assertEquals(ex.next(), ac.next());
        }
    }

    static PropertyContainer container(Map<String, Object> values) {
        PropertyContainer container = (PropertyContainer)Mockito.mock(PropertyContainer.class);
        Mockito.when((Object)container.getPropertyKeys()).thenReturn(values.keySet());
        Mockito.when((Object)container.getAllProperties()).thenReturn(values);
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Mockito.when((Object)container.getProperty(entry.getKey(), null)).thenReturn(entry.getValue());
        }
        return container;
    }
}

