/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class CollectUserAgentFilterIT
extends AbstractRestFunctionalTestBase {
    public static final String USER_AGENT = "test/1.0";
    private static FunctionalTestHelper functionalTestHelper;

    @BeforeClass
    public static void setupServer() {
        functionalTestHelper = new FunctionalTestHelper(CollectUserAgentFilterIT.server());
    }

    @Test
    public void shouldRecordUserAgent() {
        this.sendRequest(USER_AGENT);
        MatcherAssert.assertThat((Object)this.resolveDependency(UsageData.class).get(UsageDataKeys.clientNames), (Matcher)CoreMatchers.hasItem((Object)USER_AGENT));
    }

    private void sendRequest(String userAgent) {
        String url = functionalTestHelper.baseUri().toString();
        JaxRsResponse resp = RestRequest.req().header("User-Agent", userAgent).get(url);
        String json = resp.getEntity();
        resp.close();
        Assert.assertEquals((String)json, (long)200L, (long)resp.getStatus());
    }
}

