/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalDocTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.RelationshipRepresentationTest;

public class RetrieveRelationshipsFromNodeIT
extends AbstractRestFunctionalDocTestBase {
    private long nodeWithRelationships;
    private long nodeWithoutRelationships;
    private long nonExistingNode;
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;
    private long likes;

    @BeforeClass
    public static void setupServer() {
        functionalTestHelper = new FunctionalTestHelper(RetrieveRelationshipsFromNodeIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    @Before
    public void setupTheDatabase() {
        this.nodeWithRelationships = helper.createNode(new Label[0]);
        this.likes = helper.createRelationship("LIKES", this.nodeWithRelationships, helper.createNode(new Label[0]));
        helper.createRelationship("LIKES", helper.createNode(new Label[0]), this.nodeWithRelationships);
        helper.createRelationship("HATES", this.nodeWithRelationships, helper.createNode(new Label[0]));
        this.nodeWithoutRelationships = helper.createNode(new Label[0]);
        this.nonExistingNode = helper.createNode(new Label[0]);
        helper.deleteNode(this.nonExistingNode);
    }

    private JaxRsResponse sendRetrieveRequestToServer(long nodeId, String path) {
        return RestRequest.req().get(functionalTestHelper.nodeUri() + "/" + nodeId + "/relationships" + path);
    }

    private void verifyRelReps(int expectedSize, String json) throws JsonParseException {
        List relreps = JsonHelper.jsonToList((String)json);
        Assert.assertEquals((long)expectedSize, (long)relreps.size());
        for (Map relrep : relreps) {
            RelationshipRepresentationTest.verifySerialisation(relrep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldParameteriseUrisInRelationshipRepresentationWithHostHeaderValue() throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(this.getServerUri() + "db/data/relationship/" + this.likes);
            httpget.setHeader("Accept", "application/json");
            httpget.setHeader("Host", "dummy.neo4j.org");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            String entityBody = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
            System.out.println(entityBody);
            Assert.assertThat((Object)entityBody, (Matcher)Matchers.containsString((String)("http://dummy.neo4j.org/db/data/relationship/" + this.likes)));
            Assert.assertThat((Object)entityBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)this.getServerUri())));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldParameteriseUrisInRelationshipRepresentationWithoutHostHeaderUsingRequestUri() throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(this.getServerUri() + "db/data/relationship/" + this.likes);
            httpget.setHeader("Accept", "application/json");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            String entityBody = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
            Assert.assertThat((Object)entityBody, (Matcher)Matchers.containsString((String)(this.getServerUri() + "db/data/relationship/" + this.likes)));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    @Documented(value="Get all relationships.")
    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingAllRelationshipsForANode() throws JsonParseException {
        String entity = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithRelationships + "/relationships/all").entity();
        this.verifyRelReps(3, entity);
    }

    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingAllRelationshipsForANodeStreaming() throws JsonParseException {
        String entity = ((RESTRequestGenerator)this.gen.get()).withHeader("X-Stream", "true").expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithRelationships + "/relationships/all").entity();
        this.verifyRelReps(3, entity);
    }

    @Documented(value="Get incoming relationships.")
    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingIncomingRelationshipsForANode() throws JsonParseException {
        String entity = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithRelationships + "/relationships/in").entity();
        this.verifyRelReps(1, entity);
    }

    @Documented(value="Get outgoing relationships.")
    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingOutgoingRelationshipsForANode() throws JsonParseException {
        String entity = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithRelationships + "/relationships/out").entity();
        this.verifyRelReps(2, entity);
    }

    @Documented(value="Get typed relationships.\n\nNote that the \"+&+\" needs to be encoded like \"+%26+\" for example when\nusing http://curl.haxx.se/[cURL] from the terminal.")
    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingAllTypedRelationshipsForANode() throws JsonParseException {
        String entity = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithRelationships + "/relationships/all/LIKES&HATES").entity();
        this.verifyRelReps(3, entity);
    }

    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingIncomingTypedRelationshipsForANode() throws JsonParseException {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nodeWithRelationships, "/in/LIKES");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
        this.verifyRelReps(1, response.getEntity());
        response.close();
    }

    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingOutgoingTypedRelationshipsForANode() throws JsonParseException {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nodeWithRelationships, "/out/HATES");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
        this.verifyRelReps(1, response.getEntity());
        response.close();
    }

    @Documented(value="Get relationships on a node without relationships.")
    @Test
    public void shouldRespondWith200AndEmptyListOfRelationshipRepresentationsWhenGettingAllRelationshipsForANodeWithoutRelationships() throws JsonParseException {
        String entity = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithoutRelationships + "/relationships/all").entity();
        this.verifyRelReps(0, entity);
    }

    @Test
    public void shouldRespondWith200AndEmptyListOfRelationshipRepresentationsWhenGettingIncomingRelationshipsForANodeWithoutRelationships() throws JsonParseException {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nodeWithoutRelationships, "/in");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
        this.verifyRelReps(0, response.getEntity());
        response.close();
    }

    @Test
    public void shouldRespondWith200AndEmptyListOfRelationshipRepresentationsWhenGettingOutgoingRelationshipsForANodeWithoutRelationships() throws JsonParseException {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nodeWithoutRelationships, "/out");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
        this.verifyRelReps(0, response.getEntity());
        response.close();
    }

    @Test
    public void shouldRespondWith404WhenGettingAllRelationshipsForNonExistingNode() {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nonExistingNode, "/all");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldRespondWith404WhenGettingIncomingRelationshipsForNonExistingNode() {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nonExistingNode, "/in");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldRespondWith404WhenGettingIncomingRelationshipsForNonExistingNodeStreaming() {
        JaxRsResponse response = RestRequest.req().header("X-Stream", "true").get(functionalTestHelper.nodeUri() + "/" + this.nonExistingNode + "/relationships/in");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldRespondWith404WhenGettingOutgoingRelationshipsForNonExistingNode() {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nonExistingNode, "/out");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGet200WhenRetrievingValidRelationship() {
        long relationshipId = helper.createRelationship("LIKES");
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.relationshipUri(relationshipId));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGetARelationshipRepresentationInJsonWhenRetrievingValidRelationship() throws Exception {
        long relationshipId = helper.createRelationship("LIKES");
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.relationshipUri(relationshipId));
        String entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        this.isLegalJson(entity);
        response.close();
    }

    private String getServerUri() {
        return RetrieveRelationshipsFromNodeIT.server().baseUri().toString();
    }

    private void isLegalJson(String entity) throws JsonParseException {
        JsonHelper.jsonToMap((String)entity);
    }
}

