/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import java.util.concurrent.Future;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.transactional.integration.TransactionMatchers;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.test.server.HTTP;

public class TransientErrorIT
extends AbstractRestFunctionalTestBase {
    @Rule
    public final OtherThreadRule<Void> otherThread = new OtherThreadRule();

    @Test(timeout=60000L)
    public void deadlockShouldRollbackTransaction() throws Exception {
        HTTP.Response failed;
        HTTP.Response initial = HTTP.POST(TransientErrorIT.txCommitUri(), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'CREATE (n1 {prop : 1}), (n2 {prop : 2})'}]}"));
        Assert.assertThat((Object)initial.status(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)initial, TransactionMatchers.containsNoErrors());
        HTTP.Response firstInTx1 = HTTP.POST(this.txUri(), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'MATCH (n {prop : 1}) SET n.prop = 3'}]}"));
        long tx1 = TransientErrorIT.extractTxId(firstInTx1);
        HTTP.Response firstInTx2 = HTTP.POST(this.txUri(), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'MATCH (n {prop : 2}) SET n.prop = 4'}]}"));
        long tx2 = TransientErrorIT.extractTxId(firstInTx2);
        Future future = this.otherThread.execute(state -> HTTP.POST(this.txUri(tx1), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'MATCH (n {prop : 2}) SET n.prop = 5'}]}")));
        HTTP.Response secondInTx2 = HTTP.POST(this.txUri(tx2), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'MATCH (n {prop : 1}) SET n.prop = 6'}]}"));
        HTTP.Response secondInTx1 = (HTTP.Response)future.get();
        Assert.assertThat((Object)secondInTx1.status(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)secondInTx2.status(), (Matcher)CoreMatchers.is((Object)200));
        if (TransientErrorIT.containsError(secondInTx1)) {
            failed = secondInTx1;
        } else if (TransientErrorIT.containsError(secondInTx2)) {
            failed = secondInTx2;
        } else {
            failed = null;
            Assert.fail((String)"Either tx1 or tx2 is expected to fail");
        }
        Assert.assertThat((Object)failed, TransactionMatchers.hasErrors(new Status[]{Status.Transaction.DeadlockDetected}));
        HTTP.Response commit = HTTP.POST(failed.stringFromContent("commit"));
        Assert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.is((Object)404));
    }

    @Test
    public void unavailableCsvResourceShouldRollbackTransaction() throws JsonParseException {
        HTTP.Response first = HTTP.POST(this.txUri(), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'CREATE ()'}]}"));
        Assert.assertThat((Object)first.status(), (Matcher)CoreMatchers.is((Object)201));
        Assert.assertThat((Object)first, TransactionMatchers.containsNoErrors());
        long txId = TransientErrorIT.extractTxId(first);
        HTTP.Response second = HTTP.POST(this.txUri(txId), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'LOAD CSV FROM \\\"http://127.0.0.1/null/\\\" AS line CREATE (a {name:line[0]})'}]}"));
        Assert.assertThat((Object)second.status(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)second, TransactionMatchers.hasErrors(new Status[]{Status.Statement.ExternalResourceFailed}));
        HTTP.Response commit = HTTP.POST(second.stringFromContent("commit"));
        Assert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.is((Object)404));
    }

    private static boolean containsError(HTTP.Response response) throws JsonParseException {
        return response.get("errors").iterator().hasNext();
    }
}

