/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.server.rest.repr.CypherPlanRepresentation;
import org.neo4j.server.rest.repr.CypherRepresentationDispatcher;
import org.neo4j.server.rest.repr.CypherStatisticsRepresentation;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationDispatcher;
import org.neo4j.server.rest.repr.RepresentationExceptionHandlingIterable;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class CypherResultRepresentation
extends MappingRepresentation {
    private static final RepresentationDispatcher REPRESENTATION_DISPATCHER = new CypherRepresentationDispatcher();
    private final ListRepresentation resultRepresentation;
    private final ListRepresentation columns;
    private final MappingRepresentation statsRepresentation;
    private final MappingRepresentation plan;

    public CypherResultRepresentation(Result result, boolean includeStats, boolean includePlan) {
        super(RepresentationType.STRING);
        this.resultRepresentation = this.createResultRepresentation(result);
        this.columns = ListRepresentation.string((Iterable)result.columns());
        this.statsRepresentation = includeStats ? new CypherStatisticsRepresentation(result.getQueryStatistics()) : null;
        this.plan = includePlan ? CypherPlanRepresentation.newFromProvider(this.planProvider(result)) : null;
    }

    protected void serialize(MappingSerializer serializer) {
        serializer.putList("columns", this.columns);
        serializer.putList("data", this.resultRepresentation);
        if (this.statsRepresentation != null) {
            serializer.putMapping("stats", this.statsRepresentation);
        }
        if (this.plan != null) {
            serializer.putMapping("plan", this.plan);
        }
    }

    private ListRepresentation createResultRepresentation(Result executionResult) {
        final List columns = executionResult.columns();
        RepresentationExceptionHandlingIterable inner = new RepresentationExceptionHandlingIterable(Iterators.loop((Iterator)executionResult));
        return new ListRepresentation("data", (Iterable)new IterableWrapper<Representation, Map<String, Object>>(inner){

            protected Representation underlyingObjectToObject(final Map<String, Object> row) {
                return new ListRepresentation("row", (Iterable)new IterableWrapper<Representation, String>((Iterable)columns){

                    protected Representation underlyingObjectToObject(String column) {
                        return CypherResultRepresentation.this.getRepresentation(row.get(column));
                    }
                });
            }
        });
    }

    private Representation getRepresentation(Object r) {
        if (r == null) {
            return ValueRepresentation.string(null);
        }
        if (r instanceof Path) {
            return new PathRepresentation<Path>((Path)r);
        }
        if (r instanceof Iterable) {
            return this.handleIterable((Iterable)r);
        }
        if (r instanceof Node) {
            return new NodeRepresentation((Node)r);
        }
        if (r instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)r);
        }
        return (Representation)REPRESENTATION_DISPATCHER.dispatch(r, "");
    }

    private Representation handleIterable(Iterable data) {
        ArrayList<Representation> results = new ArrayList<Representation>();
        for (Object value : data) {
            Representation rep = this.getRepresentation(value);
            results.add(rep);
        }
        RepresentationType representationType = this.getType(results);
        return new ListRepresentation(representationType, results);
    }

    private RepresentationType getType(List<Representation> representations) {
        if (representations == null || representations.isEmpty()) {
            return RepresentationType.STRING;
        }
        return representations.get(0).getRepresentationType();
    }

    private Function<Object, ExecutionPlanDescription> planProvider(Result result) {
        return from -> result.getExecutionPlanDescription();
    }
}

