/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class BoltIT
extends ExclusiveServerTestBase {
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();
    private CommunityNeoServer server;

    @After
    public void stopTheServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldLaunchBolt() throws Throwable {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(new BoltConnector((String)"bolt").type.name(), "BOLT").withProperty(new BoltConnector((String)"bolt").enabled.name(), "true").withProperty(new BoltConnector((String)"bolt").encryption_level.name(), "REQUIRED").withProperty(new BoltConnector((String)"bolt").listen_address.name(), "localhost:0").usingDataDir(this.tmpDir.getRoot().getAbsolutePath()).build();
        this.server.start();
        ConnectorPortRegister connectorPortRegister = this.getDependency(ConnectorPortRegister.class);
        this.assertEventuallyServerResponds("localhost", connectorPortRegister.getLocalAddress("bolt").getPort());
    }

    @Test
    public void shouldBeAbleToSpecifyHostAndPort() throws Throwable {
        this.startServerWithBoltEnabled();
        ConnectorPortRegister connectorPortRegister = this.getDependency(ConnectorPortRegister.class);
        this.assertEventuallyServerResponds("localhost", connectorPortRegister.getLocalAddress("bolt").getPort());
    }

    @Test
    public void boltAddressShouldComeFromConnectorAdvertisedAddress() throws Throwable {
        String host = "neo4j.com";
        this.startServerWithBoltEnabled(host, 9999, "localhost", 0);
        RestRequest request = new RestRequest(this.server.baseUri()).host(host);
        JaxRsResponse response = request.get();
        Map map = JsonHelper.jsonToMap((String)response.getEntity());
        MatcherAssert.assertThat((Object)String.valueOf(map.get("bolt")), (Matcher)Matchers.containsString((String)("bolt://" + host + ":" + 9999)));
    }

    private void startServerWithBoltEnabled() throws IOException {
        this.startServerWithBoltEnabled("localhost", 7687, "localhost", 7687);
    }

    private void startServerWithBoltEnabled(String advertisedHost, int advertisedPort, String listenHost, int listenPort) throws IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(new BoltConnector((String)"bolt").type.name(), "BOLT").withProperty(new BoltConnector((String)"bolt").enabled.name(), "true").withProperty(new BoltConnector((String)"bolt").encryption_level.name(), "REQUIRED").withProperty(new BoltConnector((String)"bolt").advertised_address.name(), advertisedHost + ":" + advertisedPort).withProperty(new BoltConnector((String)"bolt").listen_address.name(), listenHost + ":" + listenPort).usingDataDir(this.tmpDir.getRoot().getAbsolutePath()).build();
        this.server.start();
    }

    private void assertEventuallyServerResponds(String host, int port) throws Exception {
        SecureSocketConnection conn = new SecureSocketConnection();
        conn.connect(new HostnamePort(host, port));
        conn.send(new byte[]{96, 96, -80, 23, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        MatcherAssert.assertThat((Object)conn.recv(4), (Matcher)Matchers.equalTo((Object)new byte[]{0, 0, 0, 1}));
    }

    private <T> T getDependency(Class<T> clazz) {
        return (T)this.server.getDatabase().getGraph().getDependencyResolver().resolveDependency(clazz);
    }
}

