/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.client.utils.URIBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;
import org.neo4j.test.server.InsecureTrustManager;

public class HttpsAccessIT
extends ExclusiveServerTestBase {
    private SSLSocketFactory originalSslSocketFactory;
    private CommunityNeoServer server;

    @Before
    public void setUp() {
        this.originalSslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
    }

    @After
    public void tearDown() {
        HttpsURLConnection.setDefaultSSLSocketFactory(this.originalSslSocketFactory);
        this.server.stop();
    }

    @Test
    public void serverShouldSupportSsl() throws Exception {
        this.startServer();
        Assert.assertThat((Object)HTTP.GET(this.httpsUri()).status(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)HTTP.GET(this.server.baseUri().toString()).status(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void txEndpointShouldReplyWithHttpsWhenItReturnsURLs() throws Exception {
        this.startServer();
        String baseUri = this.server.baseUri().toString();
        HTTP.Response response = HTTP.POST(baseUri + "db/data/transaction", HTTP.RawPayload.quotedJson("{'statements':[]}"));
        Assert.assertThat((Object)response.location(), (Matcher)CoreMatchers.startsWith((String)baseUri));
        Assert.assertThat((Object)response.get("commit").asText(), (Matcher)CoreMatchers.startsWith((String)baseUri));
    }

    @Test
    public void shouldExposeBaseUriWhenHttpEnabledAndHttpsDisabled() throws Exception {
        this.startServer(true, false);
        URI uri = this.server.baseUri();
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        HostnamePort expectedHostPort = this.addressForConnector("http");
        Assert.assertEquals((Object)expectedHostPort.getHost(), (Object)uri.getHost());
        Assert.assertEquals((long)expectedHostPort.getPort(), (long)uri.getPort());
    }

    @Test
    public void shouldExposeBaseUriWhenHttpDisabledAndHttpsEnabled() throws Exception {
        this.startServer(false, true);
        URI uri = this.server.baseUri();
        Assert.assertEquals((Object)"https", (Object)uri.getScheme());
        HostnamePort expectedHostPort = this.addressForConnector("https");
        Assert.assertEquals((Object)expectedHostPort.getHost(), (Object)uri.getHost());
        Assert.assertEquals((long)expectedHostPort.getPort(), (long)uri.getPort());
    }

    private void startServer() throws Exception {
        this.startServer(true, true);
    }

    private void startServer(boolean httpEnabled, boolean httpsEnabled) throws Exception {
        CommunityServerBuilder serverBuilder = CommunityServerBuilder.serverOnRandomPorts().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath());
        if (!httpEnabled) {
            serverBuilder.withHttpDisabled();
        }
        if (httpsEnabled) {
            serverBuilder.withHttpsEnabled();
        }
        this.server = serverBuilder.build();
        this.server.start();
        TrustManager[] trustAllCerts = new TrustManager[]{new InsecureTrustManager()};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    private String httpsUri() throws Exception {
        HostnamePort hostPort = this.addressForConnector("https");
        Assert.assertNotNull((Object)hostPort);
        return new URIBuilder().setScheme("https").setHost(hostPort.getHost()).setPort(hostPort.getPort()).build().toString();
    }

    private HostnamePort addressForConnector(String name) {
        DependencyResolver resolver = this.server.database.getGraph().getDependencyResolver();
        ConnectorPortRegister portRegister = (ConnectorPortRegister)resolver.resolveDependency(ConnectorPortRegister.class);
        return portRegister.getLocalAddress(name);
    }
}

