/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerBootstrapper;
import org.neo4j.server.database.CommunityGraphFactory;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class ServerBootstrapperTest {
    @Rule
    public final SuppressOutput suppress = SuppressOutput.suppress((SuppressOutput.Suppressible[])new SuppressOutput.Suppressible[]{SuppressOutput.System.out});
    @Rule
    public TestDirectory homeDir = TestDirectory.testDirectory();

    @Test
    public void shouldNotThrowNullPointerExceptionIfConfigurationValidationFails() throws Exception {
        ServerBootstrapper serverBootstrapper = new ServerBootstrapper(){

            protected GraphFactory createGraphFactory(Config config) {
                return new CommunityGraphFactory();
            }

            protected NeoServer createNeoServer(GraphFactory graphFactory, Config config, GraphDatabaseDependencies dependencies) {
                return (NeoServer)Mockito.mock(NeoServer.class);
            }
        };
        File dir = Files.createTempDirectory("test-server-bootstrapper", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        serverBootstrapper.start(dir, Optional.empty(), MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.database_path.name(), this.homeDir.absolutePath().getAbsolutePath()}));
        Assert.assertThat((Object)this.suppress.getOutputVoice().lines(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }
}

