/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.server.configuration.ServerSettings;

public class ServerSettingsTest {
    @Test
    public void webServerThreadCountDefaultShouldBeDocumented() {
        Config config = Config.builder().withServerDefaults().build();
        String documentedDefaultValue = (String)config.getConfigValues().entrySet().stream().filter(c -> ((String)c.getKey()).equals(ServerSettings.webserver_max_threads.name())).map(Map.Entry::getValue).findAny().orElseThrow(() -> new RuntimeException("Setting not present!")).documentedDefaultValue().orElseThrow(() -> new RuntimeException("Default value not present!"));
        Assert.assertEquals((Object)"Number of available processors, or 500 for machines which have more than 500 processors.", (Object)documentedDefaultValue);
    }

    @Test
    public void configValuesContainsConnectors() {
        Config config = Config.builder().withServerDefaults().build();
        List connectorSettings = config.getConfigValues().entrySet().stream().map(Map.Entry::getKey).filter(c -> c.startsWith("dbms.connector")).filter(c -> c.endsWith(".enabled")).collect(Collectors.toList());
        Assert.assertThat(connectorSettings, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"dbms.connector.http.enabled", "dbms.connector.https.enabled", "dbms.connector.bolt.enabled"}));
    }

    @Test
    public void connectorSettingHasItsOwnValues() {
        Config config = Config.builder().withServerDefaults().withSetting(new HttpConnector((String)"http").address, "localhost:123").build();
        ConfigValue address = config.getConfigValues().entrySet().stream().filter(c -> ((String)c.getKey()).equals("dbms.connector.http.address")).map(Map.Entry::getValue).findAny().orElseThrow(() -> new RuntimeException("Setting not present!"));
        Assert.assertTrue((boolean)address.deprecated());
        Assert.assertEquals(Optional.of("dbms.connector.http.listen_address"), (Object)address.replacement());
    }
}

