/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.TopLevelTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.Database;
import org.neo4j.values.virtual.VirtualValues;

public class CypherExecutorTest {
    private static final long CUSTOM_TRANSACTION_TIMEOUT = 1000L;
    private static final String QUERY = "create (n)";
    private Database database;
    private GraphDatabaseFacade databaseFacade;
    private DependencyResolver resolver;
    private QueryExecutionEngine executionEngine;
    private ThreadToStatementContextBridge statementBridge;
    private GraphDatabaseQueryService databaseQueryService;
    private KernelTransaction kernelTransaction;
    private Statement statement;
    private HttpServletRequest request;
    private AssertableLogProvider logProvider;

    @Before
    public void setUp() {
        this.setUpMocks();
        this.initLogProvider();
    }

    @Test
    public void startDefaultTransaction() {
        CypherExecutor cypherExecutor = new CypherExecutor(this.database, (LogProvider)this.logProvider);
        cypherExecutor.start();
        cypherExecutor.createTransactionContext(QUERY, VirtualValues.emptyMap(), this.request);
        ((GraphDatabaseQueryService)Mockito.verify((Object)this.databaseQueryService)).beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
        this.logProvider.assertNoLoggingOccurred();
    }

    @Test
    public void startTransactionWithCustomTimeout() {
        Mockito.when((Object)this.request.getHeader("max-execution-time")).thenReturn((Object)String.valueOf(1000L));
        CypherExecutor cypherExecutor = new CypherExecutor(this.database, (LogProvider)this.logProvider);
        cypherExecutor.start();
        cypherExecutor.createTransactionContext(QUERY, VirtualValues.emptyMap(), this.request);
        ((GraphDatabaseQueryService)Mockito.verify((Object)this.databaseQueryService)).beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED, 1000L, TimeUnit.MILLISECONDS);
        this.logProvider.assertNoLoggingOccurred();
    }

    @Test
    public void startDefaultTransactionWhenHeaderHasIncorrectValue() {
        Mockito.when((Object)this.request.getHeader("max-execution-time")).thenReturn((Object)"not a number");
        CypherExecutor cypherExecutor = new CypherExecutor(this.database, (LogProvider)this.logProvider);
        cypherExecutor.start();
        cypherExecutor.createTransactionContext(QUERY, VirtualValues.emptyMap(), this.request);
        ((GraphDatabaseQueryService)Mockito.verify((Object)this.databaseQueryService)).beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
        this.logProvider.rawMessageMatcher().assertContains("Fail to parse `max-execution-time` header with value: 'not a number'. Should be a positive number.");
    }

    @Test
    public void startDefaultTransactionIfTimeoutIsNegative() {
        Mockito.when((Object)this.request.getHeader("max-execution-time")).thenReturn((Object)"-2");
        CypherExecutor cypherExecutor = new CypherExecutor(this.database, (LogProvider)this.logProvider);
        cypherExecutor.start();
        cypherExecutor.createTransactionContext(QUERY, VirtualValues.emptyMap(), this.request);
        ((GraphDatabaseQueryService)Mockito.verify((Object)this.databaseQueryService)).beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
        this.logProvider.assertNoLoggingOccurred();
    }

    private void initLogProvider() {
        this.logProvider = new AssertableLogProvider(true);
    }

    private void setUpMocks() {
        this.database = (Database)Mockito.mock(Database.class);
        this.databaseFacade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
        this.resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        this.executionEngine = (QueryExecutionEngine)Mockito.mock(ExecutionEngine.class);
        this.statementBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        this.databaseQueryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        this.kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        this.statement = (Statement)Mockito.mock(Statement.class);
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        TopLevelTransaction transaction = new TopLevelTransaction(this.kernelTransaction);
        LoginContext loginContext = LoginContext.AUTH_DISABLED;
        Transaction.Type type = Transaction.Type.implicit;
        QueryRegistryOperations registryOperations = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        Mockito.when((Object)this.statement.queryRegistration()).thenReturn((Object)registryOperations);
        Mockito.when((Object)this.statementBridge.get()).thenReturn((Object)this.statement);
        Mockito.when((Object)this.kernelTransaction.securityContext()).thenReturn((Object)loginContext.authorize(s -> -1, "graph.db"));
        Mockito.when((Object)this.kernelTransaction.transactionType()).thenReturn((Object)type);
        Mockito.when((Object)this.database.getGraph()).thenReturn((Object)this.databaseFacade);
        Mockito.when((Object)this.databaseFacade.getDependencyResolver()).thenReturn((Object)this.resolver);
        Mockito.when((Object)this.resolver.resolveDependency(QueryExecutionEngine.class)).thenReturn((Object)this.executionEngine);
        Mockito.when((Object)this.resolver.resolveDependency(ThreadToStatementContextBridge.class)).thenReturn((Object)this.statementBridge);
        Mockito.when((Object)this.resolver.resolveDependency(GraphDatabaseQueryService.class)).thenReturn((Object)this.databaseQueryService);
        Mockito.when((Object)this.databaseQueryService.beginTransaction(type, loginContext)).thenReturn((Object)transaction);
        Mockito.when((Object)this.databaseQueryService.beginTransaction(type, loginContext, 1000L, TimeUnit.MILLISECONDS)).thenReturn((Object)transaction);
        Mockito.when((Object)this.databaseQueryService.getDependencyResolver()).thenReturn((Object)this.resolver);
        Mockito.when((Object)this.request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)this.request.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)this.request.getRemotePort()).thenReturn((Object)5678);
        Mockito.when((Object)this.request.getServerName()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)this.request.getServerPort()).thenReturn((Object)7474);
        Mockito.when((Object)this.request.getRequestURI()).thenReturn((Object)"/");
    }
}

