/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.helpers.UnitOfWork;

public class Transactor {
    private final UnitOfWork unitOfWork;
    private final GraphDatabaseService graphDb;
    private final int attempts;

    public Transactor(GraphDatabaseService graphDb, UnitOfWork unitOfWork) {
        this(graphDb, unitOfWork, 1);
    }

    public Transactor(GraphDatabaseService graphDb, UnitOfWork unitOfWork, int attempts) {
        assert (attempts > 0) : "The Transactor should make at least one attempt at running the transaction.";
        this.unitOfWork = unitOfWork;
        this.graphDb = graphDb;
        this.attempts = attempts;
    }

    public void execute() {
        for (int attemptsLeft = this.attempts - 1; attemptsLeft >= 0; --attemptsLeft) {
            try (Transaction tx = this.graphDb.beginTx();){
                this.unitOfWork.doWork();
                tx.success();
                continue;
            }
            catch (RuntimeException e) {
                if (attemptsLeft != 0) continue;
                throw e;
            }
        }
    }
}

