/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.integration;

import javax.management.ObjectName;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.jmx.JmxUtils;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class ServerConfigIT
extends ExclusiveServerTestBase {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private CommunityNeoServer server;

    @Test
    public void durationsAlwaysHaveUnitsInJMX() throws Throwable {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.transaction_timeout.name(), "10").build();
        this.server.start();
        ObjectName name = JmxUtils.getObjectName((GraphDatabaseService)this.server.getDatabase().getGraph(), (String)"Configuration");
        String attr = (String)JmxUtils.getAttribute((ObjectName)name, (String)GraphDatabaseSettings.transaction_timeout.name());
        MatcherAssert.assertThat((Object)attr, (Matcher)Matchers.equalTo((Object)"10000ms"));
    }

    @Test
    public void serverConfigShouldBeVisibleInJMX() throws Throwable {
        String configValue = this.tempDir.newFile().getAbsolutePath();
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(ServerSettings.run_directory.name(), configValue).build();
        this.server.start();
        ObjectName name = JmxUtils.getObjectName((GraphDatabaseService)this.server.getDatabase().getGraph(), (String)"Configuration");
        String attr = (String)JmxUtils.getAttribute((ObjectName)name, (String)ServerSettings.run_directory.name());
        MatcherAssert.assertThat((Object)attr, (Matcher)Matchers.equalTo((Object)configValue));
    }

    @After
    public void cleanup() {
        this.server.stop();
    }
}

