/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ExtensionInitializer;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.PluginLifecycle;

public class ExtensionInitializerTest {
    @Test
    public void testPluginInitialization() {
        Config config = Config.defaults((Setting)ServerSettings.transaction_idle_timeout, (String)"600");
        NeoServer neoServer = (NeoServer)Mockito.mock(NeoServer.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)neoServer.getConfig()).thenReturn((Object)config);
        ExtensionInitializer extensionInitializer = new ExtensionInitializer(neoServer);
        Collection injectableProperties = extensionInitializer.initializePackages(Collections.singletonList("org.neo4j.server.modules"));
        Assert.assertTrue((boolean)injectableProperties.stream().anyMatch(i -> ServerSettings.transaction_idle_timeout.name().equals(i.getValue())));
    }

    public static class PropertyCollectorPlugin
    implements PluginLifecycle {
        public Collection<Injectable<?>> start(GraphDatabaseService graphDatabaseService, Configuration config) {
            return Iterators.asList((Iterator)Iterators.map((Function)new StringToInjectableFunction(), (Iterator)config.getKeys()));
        }

        public void stop() {
        }

        private class StringToInjectableFunction
        implements Function<String, Injectable<?>> {
            private StringToInjectableFunction() {
            }

            @Override
            public Injectable<String> apply(final String value) {
                return new Injectable<String>(){

                    public String getValue() {
                        return value;
                    }

                    public Class<String> getType() {
                        return String.class;
                    }
                };
            }
        }
    }
}

