/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.util.Base64;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.dbms.AuthorizationHeaders;
import org.neo4j.test.server.HTTP;

public class AuthorizationHeadersTest {
    @Test
    public void shouldParseHappyPath() {
        String username = "jake";
        String password = "qwerty123456";
        String header = HTTP.basicAuthHeader(username, password);
        String[] parsed = AuthorizationHeaders.decode((String)header);
        Assert.assertEquals((Object)username, (Object)parsed[0]);
        Assert.assertEquals((Object)password, (Object)parsed[1]);
    }

    @Test
    public void shouldHandleSadPaths() {
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)""));
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)"Basic"));
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)"Basic not valid value"));
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)("Basic " + Base64.getEncoder().encodeToString("".getBytes()))));
    }
}

