/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.transactional.integration.TransactionMatchers;
import org.neo4j.test.server.HTTP;

@RunWith(value=Parameterized.class)
public class ClientErrorIT
extends AbstractRestFunctionalTestBase {
    private static final int UNIQUE_ISBN = 12345;
    @Parameterized.Parameter(value=0)
    public String query;
    @Parameterized.Parameter(value=1)
    public Status errorStatus;

    @Parameterized.Parameters(name="{0} should cause {1}")
    public static List<Object[]> queriesWithStatuses() {
        return Arrays.asList({"Not a valid query", Status.Statement.SyntaxError}, {"RETURN {foo}", Status.Statement.ParameterMissing}, {"MATCH (n) WITH n.prop AS n2 RETURN n2.prop", Status.Statement.TypeError}, {"CYPHER 1.9 EXPLAIN MATCH n RETURN n", Status.Statement.SyntaxError}, {"RETURN 10 / 0", Status.Statement.ArithmeticError}, {"CREATE INDEX ON :Person(name)", Status.Transaction.ForbiddenDueToTransactionType}, {"CREATE (n:``)", Status.Schema.TokenNameError}, {"CREATE (b:Book {isbn: 12345})", Status.Schema.ConstraintValidationFailed}, {"LOAD CSV FROM 'http://127.0.0.1/null/' AS line CREATE (a {name:line[0]})", Status.Request.InvalidFormat});
    }

    @BeforeClass
    public static void prepareDatabase() {
        HTTP.POST(ClientErrorIT.txCommitUri(), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'CREATE INDEX ON :Book(name)'}]}"));
        HTTP.POST(ClientErrorIT.txCommitUri(), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'CREATE CONSTRAINT ON (b:Book) ASSERT b.isbn IS UNIQUE'}]}"));
        HTTP.POST(ClientErrorIT.txCommitUri(), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'CREATE (b:Book {isbn: 12345})'}]}"));
    }

    @Test
    public void clientErrorShouldRollbackTheTransaction() throws JsonParseException {
        HTTP.Response first = HTTP.POST(this.txUri(), HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'CREATE (n {prop : 1})'}]}"));
        Assert.assertThat((Object)first.status(), (Matcher)CoreMatchers.is((Object)201));
        Assert.assertThat((Object)first, TransactionMatchers.containsNoErrors());
        long txId = ClientErrorIT.extractTxId(first);
        HTTP.Response malformed = HTTP.POST(this.txUri(txId), HTTP.RawPayload.quotedJson("{'statements': [{'statement': '" + this.query + "'}]}"));
        Assert.assertThat((Object)malformed.status(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)malformed, TransactionMatchers.hasErrors(this.errorStatus));
        HTTP.Response commit = HTTP.POST(first.stringFromContent("commit"));
        Assert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.is((Object)404));
    }
}

