/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rest.web.RestfulGraphDatabase;

public class TransactionWrappingRestfulGraphDatabase
extends RestfulGraphDatabase {
    private final GraphDatabaseService graph;
    private final RestfulGraphDatabase restfulGraphDatabase;

    public TransactionWrappingRestfulGraphDatabase(GraphDatabaseService graph, RestfulGraphDatabase restfulGraphDatabase) {
        super(null, null, null, null);
        this.graph = graph;
        this.restfulGraphDatabase = restfulGraphDatabase;
    }

    public Response addToNodeIndex(String indexName, String unique, String uniqueness, String postBody) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.addToNodeIndex(indexName, unique, uniqueness, postBody);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response createRelationship(long startNodeId, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.createRelationship(startNodeId, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response deleteNodeIndex(String indexName) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.deleteNodeIndex(indexName);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response getNodeRelationships(long nodeId, DatabaseActions.RelationshipDirection direction, RestfulGraphDatabase.AmpersandSeparatedCollection types) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response;
            Response response2 = response = this.restfulGraphDatabase.getNodeRelationships(nodeId, direction, types);
            return response2;
        }
    }

    public Response deleteAllNodeProperties(long nodeId) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.deleteAllNodeProperties(nodeId);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response getAllNodeProperties(long nodeId) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response;
            Response response2 = response = this.restfulGraphDatabase.getAllNodeProperties(nodeId);
            return response2;
        }
    }

    public Response createNode(String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.createNode(body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response deleteAllRelationshipProperties(long relationshipId) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.deleteAllRelationshipProperties(relationshipId);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response addToRelationshipIndex(String indexName, String unique, String uniqueness, String postBody) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.addToRelationshipIndex(indexName, unique, uniqueness, postBody);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response getIndexedNodes(String indexName, String key, String value) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response;
            Response response2 = response = this.restfulGraphDatabase.getIndexedNodes(indexName, key, value);
            return response2;
        }
    }

    public Response getRelationshipIndexRoot() {
        try (Transaction transaction = this.graph.beginTx();){
            Response response;
            Response response2 = response = this.restfulGraphDatabase.getRelationshipIndexRoot();
            return response2;
        }
    }

    public Response setRelationshipProperty(long relationshipId, String key, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.setRelationshipProperty(relationshipId, key, body);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response getSchemaConstraintsForLabelAndPropertyUniqueness(String labelName, RestfulGraphDatabase.AmpersandSeparatedCollection propertyKeys) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getSchemaConstraintsForLabelAndUniqueness(String labelName) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getSchemaConstraintsForLabel(String labelName) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getSchemaConstraints() {
        throw new UnsupportedOperationException("TODO");
    }

    public Response dropPropertyUniquenessConstraint(String labelName, RestfulGraphDatabase.AmpersandSeparatedCollection properties) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response createPropertyUniquenessConstraint(String labelName, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.createPropertyUniquenessConstraint(labelName, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response getSchemaIndexesForLabel(String labelName) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response dropSchemaIndex(String labelName, RestfulGraphDatabase.AmpersandSeparatedCollection properties) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response createSchemaIndex(String labelName, String body) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response allPaths(long startNode, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.allPaths(startNode, body);
            return response;
        }
    }

    public Response singlePath(long startNode, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.singlePath(startNode, body);
            return response;
        }
    }

    public Response deleteFromRelationshipIndex(String indexName, long id) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response deleteFromRelationshipIndexNoValue(String indexName, String key, long id) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response deleteFromRelationshipIndex(String indexName, String key, String value, long id) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.deleteFromRelationshipIndex(indexName, key, value, id);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response deleteFromNodeIndexNoKeyValue(String indexName, long id) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response deleteFromNodeIndexNoValue(String indexName, String key, long id) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response deleteFromNodeIndex(String indexName, String key, String value, long id) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.deleteFromNodeIndex(indexName, key, value, id);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response getIndexedRelationshipsByQuery(String indexName, String key, String query, String order) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getIndexedRelationshipsByQuery(indexName, key, query, order);
            return response;
        }
    }

    public Response getIndexedRelationshipsByQuery(String indexName, String query, String order) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getIndexedRelationshipsByQuery(indexName, query, order);
            return response;
        }
    }

    public Response stopAutoIndexingProperty(String type, String property) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.stopAutoIndexingProperty(type, property);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response startAutoIndexingProperty(String type, String property) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.startAutoIndexingProperty(type, property);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response getAutoIndexedProperties(String type) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getAutoIndexedProperties(type);
            return response;
        }
    }

    public Response setAutoIndexerEnabled(String type, String enable) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.setAutoIndexerEnabled(type, enable);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response isAutoIndexerEnabled(String type) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.isAutoIndexerEnabled(type);
            return response;
        }
    }

    public Response getIndexedRelationships(String indexName, String key, String value) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getIndexedRelationships(indexName, key, value);
            return response;
        }
    }

    public Response getIndexedNodesByQuery(String indexName, String key, String query, String order) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getIndexedNodesByQuery(indexName, key, query, order);
            return response;
        }
    }

    public Response getAutoIndexedNodes(String type, String key, String value) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getRelationshipFromIndexUri(String indexName, String key, String value, long id) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getRelationshipFromIndexUri(indexName, key, value, id);
            return response;
        }
    }

    public Response getNodeFromIndexUri(String indexName, String key, String value, long id) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getNodeFromIndexUri(indexName, key, value, id);
            return response;
        }
    }

    public Response deleteRelationshipIndex(String indexName) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.deleteRelationshipIndex(indexName);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response getAutoIndexedNodesByQuery(String type, String query) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getIndexedNodesByQuery(String indexName, String query, String order) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getIndexedNodesByQuery(indexName, query, order);
            return response;
        }
    }

    public Response jsonCreateRelationshipIndex(String json) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.jsonCreateRelationshipIndex(json);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response jsonCreateNodeIndex(String json) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.jsonCreateNodeIndex(json);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response getNodeIndexRoot() {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getNodeIndexRoot();
            return response;
        }
    }

    public Response deleteRelationshipProperty(long relationshipId, String key) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.deleteRelationshipProperty(relationshipId, key);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response setAllRelationshipProperties(long relationshipId, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.setAllRelationshipProperties(relationshipId, body);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response getRelationshipProperty(long relationshipId, String key) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getRelationshipProperty(relationshipId, key);
            return response;
        }
    }

    public Response getAllRelationshipProperties(long relationshipId) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getAllRelationshipProperties(relationshipId);
            return response;
        }
    }

    public Response getNodeRelationships(long nodeId, DatabaseActions.RelationshipDirection direction) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response deleteRelationship(long relationshipId) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.deleteRelationship(relationshipId);
            transaction.success();
            Response response2 = response;
            return response2;
        }
    }

    public Response getRelationship(long relationshipId) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getRelationship(relationshipId);
            return response;
        }
    }

    public Response getAllLabels(boolean inUse) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getAllLabels(inUse);
            return response;
        }
    }

    public Response getNodesWithLabelAndProperty(String labelName, UriInfo uriInfo) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response getNodeLabels(long nodeId) {
        try (Transaction ignored = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getNodeLabels(nodeId);
            return response;
        }
    }

    public Response removeNodeLabel(long nodeId, String labelName) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response setNodeLabels(long nodeId, String body) {
        throw new UnsupportedOperationException("TODO");
    }

    public Response addNodeLabel(long nodeId, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.addNodeLabel(nodeId, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response deleteNodeProperty(long nodeId, String key) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.deleteNodeProperty(nodeId, key);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response getNodeProperty(long nodeId, String key) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getNodeProperty(nodeId, key);
            return response;
        }
    }

    public Response setNodeProperty(long nodeId, String key, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.setNodeProperty(nodeId, key, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response setAllNodeProperties(long nodeId, String body) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.setAllNodeProperties(nodeId, body);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response deleteNode(long nodeId) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.deleteNode(nodeId);
            if (response.getStatus() < 300) {
                transaction.success();
            }
            Response response2 = response;
            return response2;
        }
    }

    public Response getNode(long nodeId) {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getNode(nodeId);
            return response;
        }
    }

    public Response getRoot() {
        try (Transaction transaction = this.graph.beginTx();){
            Response response = this.restfulGraphDatabase.getRoot();
            return response;
        }
    }
}

