/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.server.rest.transactional.ResultDataContentWriter;
import org.neo4j.server.rest.transactional.TransactionStateChecker;

class GraphExtractionWriter
implements ResultDataContentWriter {
    GraphExtractionWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonGenerator out, Iterable<String> columns, Result.ResultRow row, TransactionStateChecker txStateChecker) throws IOException {
        HashSet<Node> nodes = new HashSet<Node>();
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        this.extract(nodes, relationships, GraphExtractionWriter.map(columns, row));
        out.writeObjectFieldStart("graph");
        try {
            this.writeNodes(out, nodes, txStateChecker);
            this.writeRelationships(out, relationships, txStateChecker);
        }
        finally {
            out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNodes(JsonGenerator out, Iterable<Node> nodes, TransactionStateChecker txStateChecker) throws IOException {
        out.writeArrayFieldStart("nodes");
        try {
            for (Node node : nodes) {
                out.writeStartObject();
                try {
                    long nodeId = node.getId();
                    out.writeStringField("id", Long.toString(nodeId));
                    if (txStateChecker.isNodeDeletedInCurrentTx(nodeId)) {
                        this.markDeleted(out);
                        continue;
                    }
                    out.writeArrayFieldStart("labels");
                    try {
                        for (Label label : node.getLabels()) {
                            out.writeString(label.name());
                        }
                    }
                    finally {
                        out.writeEndArray();
                    }
                    this.writeProperties(out, (PropertyContainer)node);
                }
                finally {
                    out.writeEndObject();
                }
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    private void markDeleted(JsonGenerator out) throws IOException {
        out.writeBooleanField("deleted", Boolean.TRUE.booleanValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRelationships(JsonGenerator out, Iterable<Relationship> relationships, TransactionStateChecker txStateChecker) throws IOException {
        out.writeArrayFieldStart("relationships");
        try {
            for (Relationship relationship : relationships) {
                out.writeStartObject();
                try {
                    long relationshipId = relationship.getId();
                    out.writeStringField("id", Long.toString(relationshipId));
                    if (txStateChecker.isRelationshipDeletedInCurrentTx(relationshipId)) {
                        this.markDeleted(out);
                        continue;
                    }
                    out.writeStringField("type", relationship.getType().name());
                    out.writeStringField("startNode", Long.toString(relationship.getStartNode().getId()));
                    out.writeStringField("endNode", Long.toString(relationship.getEndNode().getId()));
                    this.writeProperties(out, (PropertyContainer)relationship);
                }
                finally {
                    out.writeEndObject();
                }
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties(JsonGenerator out, PropertyContainer container) throws IOException {
        out.writeObjectFieldStart("properties");
        try {
            for (Map.Entry property : container.getAllProperties().entrySet()) {
                out.writeObjectField((String)property.getKey(), property.getValue());
            }
        }
        finally {
            out.writeEndObject();
        }
    }

    private void extract(Set<Node> nodes, Set<Relationship> relationships, Iterable<?> source) {
        for (Object item : source) {
            if (item instanceof Node) {
                nodes.add((Node)item);
            } else if (item instanceof Relationship) {
                Relationship relationship = (Relationship)item;
                relationships.add(relationship);
                nodes.add(relationship.getStartNode());
                nodes.add(relationship.getEndNode());
            }
            if (item instanceof Path) {
                Path path = (Path)item;
                for (Node node : path.nodes()) {
                    nodes.add(node);
                }
                for (Relationship relationship : path.relationships()) {
                    relationships.add(relationship);
                }
                continue;
            }
            if (item instanceof Map) {
                this.extract(nodes, relationships, ((Map)item).values());
                continue;
            }
            if (!(item instanceof Iterable)) continue;
            this.extract(nodes, relationships, (Iterable)item);
        }
    }

    private static Iterable<?> map(Iterable<String> columns, final Result.ResultRow row) {
        return new IterableWrapper<Object, String>(columns){

            protected Object underlyingObjectToObject(String key) {
                return row.get(key);
            }
        };
    }
}

