/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.StreamingJsonFormat;
import org.neo4j.server.rest.transactional.ResultDataContentWriter;
import org.neo4j.server.rest.transactional.TransactionStateChecker;

class RestRepresentationWriter
implements ResultDataContentWriter {
    private final URI baseUri;

    RestRepresentationWriter(URI baseUri) {
        this.baseUri = baseUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonGenerator out, Iterable<String> columns, Result.ResultRow row, TransactionStateChecker txStateChecker) throws IOException {
        StreamingJsonFormat.StreamingRepresentationFormat format = new StreamingJsonFormat.StreamingRepresentationFormat(out, null);
        out.writeArrayFieldStart("rest");
        try {
            for (String key : columns) {
                this.write(out, format, row.get(key), txStateChecker);
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(JsonGenerator out, RepresentationFormat format, Object value, TransactionStateChecker checker) throws IOException {
        if (value instanceof Map) {
            out.writeStartObject();
            try {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    out.writeFieldName((String)entry.getKey());
                    this.write(out, format, entry.getValue(), checker);
                }
            }
            finally {
                out.writeEndObject();
            }
        } else if (value instanceof Path) {
            this.write(format, (Representation)new PathRepresentation<Path>((Path)value));
        } else if (value instanceof Iterable) {
            out.writeStartArray();
            try {
                for (Object item : (Iterable)value) {
                    this.write(out, format, item, checker);
                }
            }
            finally {
                out.writeEndArray();
            }
        } else if (value instanceof Node) {
            NodeRepresentation representation = new NodeRepresentation((Node)value);
            representation.setTransactionStateChecker(checker);
            this.write(format, (Representation)representation);
        } else if (value instanceof Relationship) {
            RelationshipRepresentation representation = new RelationshipRepresentation((Relationship)value);
            representation.setTransactionStateChecker(checker);
            this.write(format, (Representation)representation);
        } else {
            out.writeObject(value);
        }
    }

    private void write(RepresentationFormat format, Representation representation) {
        OutputFormat.write(representation, format, this.baseUri);
    }
}

