/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.rest.dbms.AuthorizationEnabledFilter;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.BasicLoginContext;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.test.AuthTokenUtil;

public class AuthorizationFilterTest {
    private final BasicAuthManager authManager = (BasicAuthManager)Mockito.mock(BasicAuthManager.class);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private final HttpServletRequest servletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    private final HttpServletResponse servletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    private final FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.servletResponse.getOutputStream()).thenReturn((Object)new ServletOutputStream(){

            public void write(int b) {
                AuthorizationFilterTest.this.outputStream.write(b);
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Test
    public void shouldAllowOptionsRequests() throws Exception {
        AuthorizationEnabledFilter filter = new AuthorizationEnabledFilter(() -> this.authManager, (LogProvider)this.logProvider, new Pattern[0]);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"OPTIONS");
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)ArgumentMatchers.same((Object)this.servletRequest), (ServletResponse)ArgumentMatchers.same((Object)this.servletResponse));
    }

    @Test
    public void shouldWhitelistMatchingUris() throws Exception {
        AuthorizationEnabledFilter filter = new AuthorizationEnabledFilter(() -> this.authManager, (LogProvider)this.logProvider, new Pattern[]{Pattern.compile("/"), Pattern.compile("/browser.*")});
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/", (Object[])new String[]{"/browser/index.html"});
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)ArgumentMatchers.same((Object)this.servletRequest), (ServletResponse)ArgumentMatchers.same((Object)this.servletResponse));
    }

    @Test
    public void shouldRequireAuthorizationForNonWhitelistedUris() throws Exception {
        AuthorizationEnabledFilter filter = new AuthorizationEnabledFilter(() -> this.authManager, (LogProvider)this.logProvider, new Pattern[]{Pattern.compile("/"), Pattern.compile("/browser.*")});
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(401);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("WWW-Authenticate", "Basic realm=\"Neo4j\"");
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.Unauthorized\""));
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"No authentication header supplied.\""));
    }

    @Test
    public void shouldRequireValidAuthorizationHeader() throws Exception {
        AuthorizationEnabledFilter filter = new AuthorizationEnabledFilter(() -> this.authManager, (LogProvider)this.logProvider, new Pattern[0]);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)"NOT A VALID VALUE");
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(400);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"Invalid authentication header.\""));
    }

    @Test
    public void shouldNotAuthorizeInvalidCredentials() throws Exception {
        AuthorizationEnabledFilter filter = new AuthorizationEnabledFilter(() -> this.authManager, (LogProvider)this.logProvider, new Pattern[0]);
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(StandardCharsets.UTF_8));
        BasicLoginContext loginContext = (BasicLoginContext)Mockito.mock(BasicLoginContext.class);
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.servletRequest.getRemoteAddr()).thenReturn((Object)"remote_ip_address");
        Mockito.when((Object)this.authManager.login(AuthTokenUtil.authTokenArgumentMatcher((Map)SecurityTestUtils.authToken((String)"foo", (String)"bar")))).thenReturn((Object)loginContext);
        Mockito.when((Object)loginContext.subject()).thenReturn((Object)authSubject);
        Mockito.when((Object)authSubject.getAuthenticationResult()).thenReturn((Object)AuthenticationResult.FAILURE);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(AuthorizationEnabledFilter.class).warn("Failed authentication attempt for '%s' from %s", new Object[]{"foo", "remote_ip_address"})});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(401);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.Unauthorized\""));
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"Invalid username or password.\""));
    }

    @Test
    public void shouldAuthorizeWhenPasswordChangeRequiredForWhitelistedPath() throws Exception {
        AuthorizationEnabledFilter filter = new AuthorizationEnabledFilter(() -> this.authManager, (LogProvider)this.logProvider, new Pattern[0]);
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(StandardCharsets.UTF_8));
        BasicLoginContext loginContext = (BasicLoginContext)Mockito.mock(BasicLoginContext.class);
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/user/foo");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.login(AuthTokenUtil.authTokenArgumentMatcher((Map)SecurityTestUtils.authToken((String)"foo", (String)"bar")))).thenReturn((Object)loginContext);
        Mockito.when((Object)loginContext.subject()).thenReturn((Object)authSubject);
        Mockito.when((Object)authSubject.getAuthenticationResult()).thenReturn((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)ArgumentMatchers.eq((Object)new AuthorizedRequestWrapper("BASIC", "foo", this.servletRequest, LoginContext.AUTH_DISABLED)), (ServletResponse)ArgumentMatchers.same((Object)this.servletResponse));
    }

    @Test
    public void shouldNotAuthorizeWhenPasswordChangeRequired() throws Exception {
        AuthorizationEnabledFilter filter = new AuthorizationEnabledFilter(() -> this.authManager, (LogProvider)this.logProvider, new Pattern[0]);
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(StandardCharsets.UTF_8));
        BasicLoginContext loginContext = (BasicLoginContext)Mockito.mock(BasicLoginContext.class);
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getRequestURL()).thenReturn((Object)new StringBuffer("http://bar.baz:7474/db/data/"));
        Mockito.when((Object)this.servletRequest.getRequestURI()).thenReturn((Object)"/db/data/");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.login(AuthTokenUtil.authTokenArgumentMatcher((Map)SecurityTestUtils.authToken((String)"foo", (String)"bar")))).thenReturn((Object)loginContext);
        Mockito.when((Object)loginContext.subject()).thenReturn((Object)authSubject);
        Mockito.when((Object)authSubject.getAuthenticationResult()).thenReturn((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(403);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"password_change\" : \"http://bar.baz:7474/user/foo/password\""));
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.Forbidden\""));
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"User is required to change their password.\""));
    }

    @Test
    public void shouldNotAuthorizeWhenTooManyAttemptsMade() throws Exception {
        AuthorizationEnabledFilter filter = new AuthorizationEnabledFilter(() -> this.authManager, (LogProvider)this.logProvider, new Pattern[0]);
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(StandardCharsets.UTF_8));
        BasicLoginContext loginContext = (BasicLoginContext)Mockito.mock(BasicLoginContext.class);
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.login(AuthTokenUtil.authTokenArgumentMatcher((Map)SecurityTestUtils.authToken((String)"foo", (String)"bar")))).thenReturn((Object)loginContext);
        Mockito.when((Object)loginContext.subject()).thenReturn((Object)authSubject);
        Mockito.when((Object)authSubject.getAuthenticationResult()).thenReturn((Object)AuthenticationResult.TOO_MANY_ATTEMPTS);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(429);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.AuthenticationRateLimit\""));
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"Too many failed authentication requests. Please wait 5 seconds and try again.\""));
    }

    @Test
    public void shouldAuthorizeWhenValidCredentialsSupplied() throws Exception {
        AuthorizationEnabledFilter filter = new AuthorizationEnabledFilter(() -> this.authManager, (LogProvider)this.logProvider, new Pattern[0]);
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(StandardCharsets.UTF_8));
        BasicLoginContext loginContext = (BasicLoginContext)Mockito.mock(BasicLoginContext.class);
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.login(AuthTokenUtil.authTokenArgumentMatcher((Map)SecurityTestUtils.authToken((String)"foo", (String)"bar")))).thenReturn((Object)loginContext);
        Mockito.when((Object)loginContext.subject()).thenReturn((Object)authSubject);
        Mockito.when((Object)authSubject.getAuthenticationResult()).thenReturn((Object)AuthenticationResult.SUCCESS);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)ArgumentMatchers.eq((Object)new AuthorizedRequestWrapper("BASIC", "foo", this.servletRequest, LoginContext.AUTH_DISABLED)), (ServletResponse)ArgumentMatchers.same((Object)this.servletResponse));
    }

    @Test
    public void shouldIncludeCrippledAuthHeaderIfBrowserIsTheOneCalling() throws Throwable {
        AuthorizationEnabledFilter filter = new AuthorizationEnabledFilter(() -> this.authManager, (LogProvider)this.logProvider, new Pattern[]{Pattern.compile("/"), Pattern.compile("/browser.*")});
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("X-Ajax-Browser-Auth")).thenReturn((Object)"true");
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(401);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("WWW-Authenticate", "None");
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.Unauthorized\""));
        Assert.assertThat((Object)this.outputStream.toString(StandardCharsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"No authentication header supplied.\""));
    }
}

