/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.CommunityDiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.test.server.EntityOutputFormat;

@RunWith(value=Parameterized.class)
public class DiscoveryServiceTest {
    private final NeoServer neoServer = (NeoServer)Mockito.mock(NeoServer.class, (Answer)Answers.RETURNS_DEEP_STUBS);
    private final ConnectorPortRegister portRegistry = (ConnectorPortRegister)Mockito.mock(ConnectorPortRegister.class);
    private URI baseUri;
    private URI dataUri;
    private URI managementUri;
    private Consumer<ConnectorPortRegister> portRegistryOverrider;
    private Consumer<Config> configOverrider;
    private String expectedDataUri;
    private String expectedManagementUri;
    private String expectedBoltUri;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> cases = new ArrayList<Object[]>();
        cases.add(new Object[]{"http://localhost:7474", "http://localhost:7474", null, null, "bolt://localhost:7687"});
        cases.add(new Object[]{"https://localhost:7473", "https://localhost:7473", null, null, "bolt://localhost:7687"});
        cases.add(new Object[]{"http://www.example.com", "http://www.example.com", null, null, "bolt://www.example.com:7687"});
        cases.add(new Object[]{"http://localhost:7474 - 0.0.0.0", "http://localhost:7474", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("0.0.0.0"), "bolt://localhost:7687"});
        cases.add(new Object[]{"https://localhost:7473 - 0.0.0.0", "https://localhost:7473", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("0.0.0.0"), "bolt://localhost:7687"});
        cases.add(new Object[]{"http://www.example.com - 0.0.0.0", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("0.0.0.0"), "bolt://www.example.com:7687"});
        cases.add(new Object[]{"http://localhost:7474 - ::", "http://localhost:7474", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), "bolt://localhost:7687"});
        cases.add(new Object[]{"https://localhost:7473 - ::", "https://localhost:7473", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), "bolt://localhost:7687"});
        cases.add(new Object[]{"http://www.example.com - ::", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), "bolt://www.example.com:7687"});
        cases.add(new Object[]{"http://localhost:7474 - [::]:8888", "http://localhost:7474", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), DiscoveryServiceTest.overrideWithListenAddress("::", 8888)), "bolt://localhost:8888"});
        cases.add(new Object[]{"https://localhost:7473 - [::]:8888", "https://localhost:7473", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), DiscoveryServiceTest.overrideWithListenAddress("::", 8888)), "bolt://localhost:8888"});
        cases.add(new Object[]{"http://www.example.com - [::]:8888", "http://www.example.com", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), DiscoveryServiceTest.overrideWithListenAddress("::", 8888)), "bolt://www.example.com:8888"});
        cases.add(new Object[]{"http://www.example.com (advertised 1)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithAdvertisedAddress("www.example.com", 8898), "bolt://www.example.com:8898"});
        cases.add(new Object[]{"http://www.example.com (advertised 2)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithAdvertisedAddress("www2.example.com", 7576), "bolt://www2.example.com:7576"});
        cases.add(new Object[]{"http://www.example.com (advertised 3)", "http://www.example.com", DiscoveryServiceTest.register("bolt", "localhost", 9999), DiscoveryServiceTest.overrideWithAdvertisedAddress("www2.example.com", 0), "bolt://www2.example.com:9999"});
        cases.add(new Object[]{"http://www.example.com (discoverable 1)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDiscoverable("bolt://www.notanexample.com:7777"), "bolt://www.notanexample.com:7777"});
        cases.add(new Object[]{"http://www.example.com (discoverable 2)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDiscoverable("something://www.notanexample.com:7777"), "something://www.notanexample.com:7777"});
        cases.add(new Object[]{"http://www.example.com (discoverable and advertised 1)", "http://www.example.com", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDiscoverable("bolt://www.notanexample.com:7777"), DiscoveryServiceTest.overrideWithAdvertisedAddress("www.notanexample2.com", 8888)), "bolt://www.notanexample.com:7777"});
        cases.add(new Object[]{"http://www.example.com (discoverable and advertised 2)", "http://www.example.com", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithAdvertisedAddress("www.notanexample2.com", 8888), DiscoveryServiceTest.overrideWithDiscoverable("bolt://www.notanexample.com:7777")), "bolt://www.notanexample.com:7777"});
        return cases;
    }

    public DiscoveryServiceTest(String description, String baseUri, Consumer<ConnectorPortRegister> portRegistryOverrider, Consumer<Config> configOverrider, String expectedBoltUri) throws Throwable {
        this.baseUri = new URI(baseUri);
        this.dataUri = new URI("/data");
        this.managementUri = new URI("/management");
        this.portRegistryOverrider = portRegistryOverrider;
        this.configOverrider = configOverrider;
        this.expectedDataUri = this.baseUri.resolve(this.dataUri).toString();
        this.expectedManagementUri = this.baseUri.resolve(this.managementUri).toString();
        this.expectedBoltUri = expectedBoltUri;
    }

    @Before
    public void setUp() throws URISyntaxException {
        if (this.portRegistryOverrider != null) {
            this.portRegistryOverrider.accept(this.portRegistry);
        } else {
            Mockito.when((Object)this.portRegistry.getLocalAddress("bolt")).thenReturn((Object)new HostnamePort("localhost", 7687));
        }
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)dependencyResolver.resolveDependency(ConnectorPortRegister.class)).thenReturn((Object)this.portRegistry);
        Mockito.when((Object)this.neoServer.getDatabase().getGraph().getDependencyResolver()).thenReturn((Object)dependencyResolver);
    }

    private Config mockConfig() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(GraphDatabaseSettings.auth_enabled.name(), "false");
        settings.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
        settings.put(new BoltConnector((String)"bolt").enabled.name(), "true");
        settings.put(ServerSettings.management_api_path.name(), this.managementUri.toString());
        settings.put(ServerSettings.rest_api_path.name(), this.dataUri.toString());
        Config config = Config.defaults(settings);
        if (this.configOverrider != null) {
            this.configOverrider.accept(config);
        }
        return config;
    }

    private DiscoveryService testDiscoveryService() throws URISyntaxException {
        Config config = this.mockConfig();
        return new DiscoveryService(config, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), this.baseUri, null), CommunityDiscoverableURIs.communityDiscoverableURIs((Config)config, (ConnectorPortRegister)this.portRegistry));
    }

    @Test
    public void shouldReturnValidJSON() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo(this.baseUri));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"\"\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"null")));
    }

    private UriInfo uriInfo(URI baseUri) {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getBaseUri()).thenReturn((Object)baseUri);
        return uriInfo;
    }

    @Test
    public void shouldReturnBoltURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo(this.baseUri));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"bolt\" : \"" + this.expectedBoltUri)));
    }

    @Test
    public void shouldReturnDataURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo(this.baseUri));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"data\" : \"" + this.expectedDataUri + "/\"")));
    }

    @Test
    public void shouldReturnManagementURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo(this.baseUri));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"management\" : \"" + this.expectedManagementUri + "/\"")));
    }

    @Test
    public void shouldReturnRedirectToAbsoluteAPIUsingOutputFormat() throws Exception {
        Config config = Config.defaults((Setting)ServerSettings.browser_path, (String)"/browser/");
        String baseUri = "http://www.example.com:5435";
        DiscoveryService ds = new DiscoveryService(config, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(baseUri), null), CommunityDiscoverableURIs.communityDiscoverableURIs((Config)config, null));
        Response response = ds.redirectToBrowser();
        Assert.assertThat((Object)response.getMetadata().getFirst((Object)"Location"), (Matcher)Matchers.is((Object)new URI("http://www.example.com:5435/browser/")));
    }

    private static Consumer<ConnectorPortRegister> register(String connector, String host, int port) {
        return register -> Mockito.when((Object)register.getLocalAddress(connector)).thenReturn((Object)new HostnamePort(host, port));
    }

    private static Consumer<ConnectorPortRegister> combineRegisterers(Consumer<ConnectorPortRegister> ... overriders) {
        return config -> {
            for (Consumer overrider : overriders) {
                overrider.accept(config);
            }
        };
    }

    private static Consumer<Config> overrideWithAdvertisedAddress(String host, int port) {
        return config -> config.augment(new BoltConnector((String)"bolt").advertised_address.name(), AdvertisedSocketAddress.advertisedAddress((String)host, (int)port));
    }

    private static Consumer<Config> overrideWithListenAddress(String host, int port) {
        return config -> config.augment(new BoltConnector((String)"bolt").listen_address.name(), AdvertisedSocketAddress.advertisedAddress((String)host, (int)port));
    }

    private static Consumer<Config> overrideWithDefaultListenAddress(String host) {
        return config -> config.augment(GraphDatabaseSettings.default_listen_address, host);
    }

    private static Consumer<Config> overrideWithDiscoverable(String uri) {
        return config -> config.augment(ServerSettings.bolt_discoverable_address, uri);
    }

    @SafeVarargs
    private static Consumer<Config> combineConfigOverriders(Consumer<Config> ... overriders) {
        return config -> {
            for (Consumer overrider : overriders) {
                overrider.accept(config);
            }
        };
    }
}

