/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.DefaultFormat;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.ListWrappingWriter;
import org.neo4j.server.rest.repr.formats.MapWrappingWriter;

public class CompactJsonFormat
extends RepresentationFormat {
    public static final MediaType MEDIA_TYPE = new MediaType(MediaType.APPLICATION_JSON_TYPE.getType(), MediaType.APPLICATION_JSON_TYPE.getSubtype(), MapUtil.stringMap((String[])new String[]{"compact", "true"}));

    public CompactJsonFormat() {
        super(MEDIA_TYPE);
    }

    protected ListWriter serializeList(String type) {
        return new ListWrappingWriter(new ArrayList<Object>());
    }

    protected String complete(ListWriter serializer) {
        return JsonHelper.createJsonFrom(((ListWrappingWriter)serializer).data);
    }

    protected MappingWriter serializeMapping(String type) {
        MappingTemplate template = MappingTemplate.TEMPLATES.get(type);
        if (template == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)("Cannot represent \"" + type + "\" as compactJson")).build());
        }
        return new CompactJsonWriter(template);
    }

    protected String complete(MappingWriter serializer) {
        return ((CompactJsonWriter)serializer).complete();
    }

    protected String serializeValue(String type, Object value) {
        return JsonHelper.createJsonFrom(value);
    }

    private boolean empty(String input) {
        return input == null || "".equals(input.trim());
    }

    public Map<String, Object> readMap(String input, String ... requiredKeys) throws BadInputException {
        if (this.empty(input)) {
            return DefaultFormat.validateKeys(Collections.emptyMap(), requiredKeys);
        }
        try {
            return DefaultFormat.validateKeys(JsonHelper.jsonToMap(this.stripByteOrderMark(input)), requiredKeys);
        }
        catch (JsonParseException ex) {
            throw new BadInputException((Throwable)ex);
        }
    }

    public List<Object> readList(String input) {
        throw new UnsupportedOperationException("Not implemented: JsonInput.readList()");
    }

    public Object readValue(String input) throws BadInputException {
        if (this.empty(input)) {
            return Collections.emptyMap();
        }
        try {
            return JsonHelper.assertSupportedPropertyValue(JsonHelper.readJson(this.stripByteOrderMark(input)));
        }
        catch (JsonParseException ex) {
            throw new BadInputException((Throwable)ex);
        }
    }

    public URI readUri(String input) throws BadInputException {
        try {
            return new URI(this.readValue(input).toString());
        }
        catch (URISyntaxException e) {
            throw new BadInputException((Throwable)e);
        }
    }

    private String stripByteOrderMark(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == '\ufeff') {
            return string.substring(1);
        }
        return string;
    }

    private static class CompactJsonWriter
    extends MapWrappingWriter {
        private final MappingTemplate template;

        CompactJsonWriter(MappingTemplate template) {
            super(new HashMap<String, Object>(), true);
            this.template = template;
        }

        @Override
        protected MappingWriter newMapping(String type, String key) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.data.put(key, map);
            return new MapWrappingWriter(map, this.interactive);
        }

        @Override
        protected void writeValue(String type, String key, Object value) {
            this.data.put(key, value);
        }

        @Override
        protected ListWriter newList(String type, String key) {
            ArrayList<Object> list = new ArrayList<Object>();
            this.data.put(key, list);
            return new ListWrappingWriter(list, this.interactive);
        }

        String complete() {
            return this.template.render(this.data);
        }
    }

    private static enum MappingTemplate {
        NODE(Representation.NODE){

            @Override
            String render(Map<String, Object> serialized) {
                return JsonHelper.createJsonFrom(MapUtil.map((Object[])new Object[]{"self", serialized.get("self"), "data", serialized.get("data")}));
            }
        }
        ,
        RELATIONSHIP(Representation.RELATIONSHIP){

            @Override
            String render(Map<String, Object> serialized) {
                return JsonHelper.createJsonFrom(MapUtil.map((Object[])new Object[]{"self", serialized.get("self"), "data", serialized.get("data")}));
            }
        }
        ,
        STRING(Representation.STRING){

            @Override
            String render(Map<String, Object> serialized) {
                return JsonHelper.createJsonFrom(serialized);
            }
        }
        ,
        EXCEPTION(Representation.EXCEPTION){

            @Override
            String render(Map<String, Object> data) {
                return JsonHelper.createJsonFrom(data);
            }
        };

        private final String key;
        static final Map<String, MappingTemplate> TEMPLATES;

        private MappingTemplate(String key) {
            this.key = key;
        }

        abstract String render(Map<String, Object> var1);

        static {
            TEMPLATES = new HashMap<String, MappingTemplate>();
            for (MappingTemplate template : MappingTemplate.values()) {
                TEMPLATES.put(template.key, template);
            }
        }
    }
}

