/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.repr.DiscoveryRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;
import org.neo4j.server.rest.repr.Serializer;

public class DiscoveryRepresentationTest {
    @Test
    public void shouldCreateAMapContainingDataAndManagementURIs() throws URISyntaxException {
        String managementUri = "/management";
        String dataUri = "/data";
        DiscoveryRepresentation dr = new DiscoveryRepresentation(new DiscoverableURIs.Builder().add("management", managementUri, DiscoverableURIs.Precedence.NORMAL).add("data", dataUri, DiscoverableURIs.Precedence.NORMAL).add("bolt", new URI("bolt://localhost:7687"), DiscoverableURIs.Precedence.NORMAL).build());
        Map<String, Object> mapOfUris = RepresentationTestAccess.serialize((MappingRepresentation)dr);
        Object mappedManagementUri = mapOfUris.get("management");
        Object mappedDataUri = mapOfUris.get("data");
        Object mappedBoltUri = mapOfUris.get("bolt");
        Assert.assertNotNull((Object)mappedManagementUri);
        Assert.assertNotNull((Object)mappedDataUri);
        Assert.assertNotNull((Object)mappedBoltUri);
        URI baseUri = RepresentationTestBase.BASE_URI;
        Assert.assertEquals((Object)mappedManagementUri.toString(), (Object)Serializer.joinBaseWithRelativePath((URI)baseUri, (String)managementUri));
        Assert.assertEquals((Object)mappedDataUri.toString(), (Object)Serializer.joinBaseWithRelativePath((URI)baseUri, (String)dataUri));
        Assert.assertEquals((Object)mappedBoltUri.toString(), (Object)"bolt://localhost:7687");
    }
}

