/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.HashMap;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.ExceptionRepresentation;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.formats.MapWrappingWriter;

public class ExceptionRepresentationTest {
    @Test
    public void shouldIncludeCause() throws Exception {
        ExceptionRepresentation rep = new ExceptionRepresentation((Throwable)new RuntimeException("Hoho", new RuntimeException("Haha", new RuntimeException("HAHA!"))));
        JsonNode out = this.serialize(rep);
        Assert.assertThat((Object)out.get("cause").get("message").asText(), (Matcher)CoreMatchers.is((Object)"Haha"));
        Assert.assertThat((Object)out.get("cause").get("cause").get("message").asText(), (Matcher)CoreMatchers.is((Object)"HAHA!"));
    }

    @Test
    public void shouldRenderErrorsWithNeo4jStatusCode() throws Exception {
        ExceptionRepresentation rep = new ExceptionRepresentation((Throwable)new KernelException((Status)Status.General.UnknownError, "Hello", new Object[0]){});
        JsonNode out = this.serialize(rep);
        Assert.assertThat((Object)out.get("errors").get(0).get("code").asText(), (Matcher)Matchers.equalTo((Object)"Neo.DatabaseError.General.UnknownError"));
        Assert.assertThat((Object)out.get("errors").get(0).get("message").asText(), (Matcher)Matchers.equalTo((Object)"Hello"));
    }

    @Test
    public void shouldExcludeLegacyFormatIfAsked() throws Exception {
        ExceptionRepresentation rep = new ExceptionRepresentation((Throwable)new KernelException((Status)Status.General.UnknownError, "Hello", new Object[0]){}, false);
        JsonNode out = this.serialize(rep);
        Assert.assertThat((Object)out.get("errors").get(0).get("code").asText(), (Matcher)Matchers.equalTo((Object)"Neo.DatabaseError.General.UnknownError"));
        Assert.assertThat((Object)out.get("errors").get(0).get("message").asText(), (Matcher)Matchers.equalTo((Object)"Hello"));
        Assert.assertThat((Object)out.has("message"), (Matcher)Matchers.equalTo((Object)false));
    }

    private JsonNode serialize(ExceptionRepresentation rep) throws JsonParseException {
        HashMap output = new HashMap();
        MappingSerializer serializer = new MappingSerializer((MappingWriter)new MapWrappingWriter(output), URI.create(""), (ExtensionInjector)Mockito.mock(ExtensionInjector.class));
        rep.serialize(serializer);
        return JsonHelper.jsonNode((String)JsonHelper.createJsonFrom(output));
    }
}

