/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.ssl;

import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.security.ssl.HttpsRequestCustomizer;

public class HttpsRequestCustomizerTest {
    @Test
    public void shouldSetRequestSchemeToHttps() {
        HttpConfiguration.Customizer customizer = HttpsRequestCustomizerTest.newCustomizer();
        Request request = (Request)Mockito.mock(Request.class);
        HttpsRequestCustomizerTest.customize(customizer, request);
        ((Request)Mockito.verify((Object)request)).setScheme(HttpScheme.HTTPS.asString());
    }

    @Test
    public void shouldAddHstsHeaderWhenConfigured() {
        String configuredValue = "max-age=3600; includeSubDomains";
        HttpConfiguration.Customizer customizer = HttpsRequestCustomizerTest.newCustomizer(configuredValue);
        Request request = HttpsRequestCustomizerTest.newRequest();
        HttpsRequestCustomizerTest.customize(customizer, request);
        String receivedValue = request.getResponse().getHttpFields().get(HttpHeader.STRICT_TRANSPORT_SECURITY);
        Assert.assertEquals((Object)configuredValue, (Object)receivedValue);
    }

    @Test
    public void shouldNotAddHstsHeaderWhenNotConfigured() {
        HttpConfiguration.Customizer customizer = HttpsRequestCustomizerTest.newCustomizer();
        Request request = HttpsRequestCustomizerTest.newRequest();
        HttpsRequestCustomizerTest.customize(customizer, request);
        String hstsValue = request.getResponse().getHttpFields().get(HttpHeader.STRICT_TRANSPORT_SECURITY);
        Assert.assertNull((Object)hstsValue);
    }

    private static void customize(HttpConfiguration.Customizer customizer, Request request) {
        customizer.customize((Connector)Mockito.mock(Connector.class), new HttpConfiguration(), request);
    }

    private static Request newRequest() {
        HttpChannel channel = (HttpChannel)Mockito.mock(HttpChannel.class);
        Response response = new Response(channel, (HttpOutput)Mockito.mock(HttpOutput.class));
        Request request = new Request(channel, (HttpInput)Mockito.mock(HttpInput.class));
        Mockito.when((Object)channel.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)channel.getResponse()).thenReturn((Object)response);
        return request;
    }

    private static HttpConfiguration.Customizer newCustomizer() {
        return HttpsRequestCustomizerTest.newCustomizer(null);
    }

    private static HttpConfiguration.Customizer newCustomizer(String hstsValue) {
        Config config = Config.defaults((Setting)ServerSettings.http_strict_transport_security, (String)hstsValue);
        return new HttpsRequestCustomizer(config);
    }
}

