/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.ServerBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

public abstract class BaseBootstrapperIT
extends ExclusiveServerTestBase {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    protected ServerBootstrapper bootstrapper;

    @Before
    public void before() throws IOException {
        this.bootstrapper = this.newBootstrapper();
        SelfSignedCertificateFactory.create((File)this.testDirectory.homeDir());
    }

    @After
    public void after() {
        if (this.bootstrapper != null) {
            this.bootstrapper.stop();
        }
    }

    protected abstract ServerBootstrapper newBootstrapper();

    @Test
    public void shouldStartStopNeoServerWithoutAnyConfigFiles() throws Throwable {
        int resultCode = ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])BaseBootstrapperIT.withConnectorsOnRandomPortsConfig(this.getAdditionalArguments()));
        Assert.assertEquals((long)0L, (long)resultCode);
        org.neo4j.test.assertion.Assert.assertEventually((String)"Server was not started", () -> ((ServerBootstrapper)this.bootstrapper).isRunning(), (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    protected String[] getAdditionalArguments() throws IOException {
        return new String[]{"--home-dir", this.testDirectory.directory("home-dir", new String[0]).getAbsolutePath(), "-c", this.configOption(GraphDatabaseSettings.data_directory, this.testDirectory.homeDir().getAbsolutePath()), "-c", this.configOption(GraphDatabaseSettings.logs_directory, this.testDirectory.homeDir().getAbsolutePath())};
    }

    @Test
    public void canSpecifyConfigFile() throws Throwable {
        File configFile = this.testDirectory.file("neo4j.conf", new String[0]);
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.forced_kernel_id.name(), "ourcustomvalue"});
        properties.putAll(ServerTestUtils.getDefaultRelativeProperties(this.testDirectory.homeDir()));
        properties.putAll(BaseBootstrapperIT.connectorsOnRandomPortsConfig());
        MapUtil.store((Map)properties, (File)configFile);
        ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.directory("home-dir", new String[0]).getAbsolutePath(), "--config-dir", configFile.getParentFile().getAbsolutePath()});
        Assert.assertThat((Object)((String)this.bootstrapper.getServer().getConfig().get(GraphDatabaseSettings.forced_kernel_id)), (Matcher)Matchers.equalTo((Object)"ourcustomvalue"));
    }

    @Test
    public void canOverrideConfigValues() throws Throwable {
        File configFile = this.testDirectory.file("neo4j.conf", new String[0]);
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.forced_kernel_id.name(), "thisshouldnotshowup"});
        properties.putAll(ServerTestUtils.getDefaultRelativeProperties(this.testDirectory.homeDir()));
        properties.putAll(BaseBootstrapperIT.connectorsOnRandomPortsConfig());
        MapUtil.store((Map)properties, (File)configFile);
        ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.directory("home-dir", new String[0]).getAbsolutePath(), "--config-dir", configFile.getParentFile().getAbsolutePath(), "-c", this.configOption(GraphDatabaseSettings.forced_kernel_id, "mycustomvalue")});
        Assert.assertThat((Object)((String)this.bootstrapper.getServer().getConfig().get(GraphDatabaseSettings.forced_kernel_id)), (Matcher)Matchers.equalTo((Object)"mycustomvalue"));
    }

    @Test
    public void shouldStartWithHttpHttpsAndBoltDisabled() throws Exception {
        this.testStartupWithConnectors(false, false, false);
    }

    @Test
    public void shouldStartWithHttpEnabledAndHttpsBoltDisabled() throws Exception {
        this.testStartupWithConnectors(true, false, false);
    }

    @Test
    public void shouldStartWithHttpsEnabledAndHttpBoltDisabled() throws Exception {
        this.testStartupWithConnectors(false, true, false);
    }

    @Test
    public void shouldStartWithBoltEnabledAndHttpHttpsDisabled() throws Exception {
        this.testStartupWithConnectors(false, false, true);
    }

    @Test
    public void shouldStartWithHttpHttpsEnabledAndBoltDisabled() throws Exception {
        this.testStartupWithConnectors(true, true, false);
    }

    @Test
    public void shouldStartWithHttpBoltEnabledAndHttpsDisabled() throws Exception {
        this.testStartupWithConnectors(true, false, true);
    }

    @Test
    public void shouldStartWithHttpsBoltEnabledAndHttpDisabled() throws Exception {
        this.testStartupWithConnectors(false, true, true);
    }

    @Test
    public void shouldHaveSameLayoutAsEmbedded() throws Exception {
        File serverDir = this.testDirectory.directory("server-dir", new String[0]);
        ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])BaseBootstrapperIT.withConnectorsOnRandomPortsConfig("--home-dir", serverDir.getAbsolutePath()));
        org.neo4j.test.assertion.Assert.assertEventually((String)"Server was not started", () -> ((ServerBootstrapper)this.bootstrapper).isRunning(), (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        Neo4jLayout serverLayout = this.bootstrapper.getServer().getDatabaseService().getDatabase().databaseLayout().getNeo4jLayout();
        this.bootstrapper.stop();
        File embeddedDir = this.testDirectory.directory("embedded-dir", new String[0]);
        DatabaseManagementService dbms = this.newEmbeddedDbms(embeddedDir);
        Neo4jLayout embeddedLayout = ((GraphDatabaseAPI)dbms.database("neo4j")).databaseLayout().getNeo4jLayout();
        dbms.shutdown();
        Assert.assertEquals((Object)FileUtils.relativePath((File)serverDir, (File)serverLayout.homeDirectory()), (Object)FileUtils.relativePath((File)embeddedDir, (File)embeddedLayout.homeDirectory()));
        Assert.assertEquals((Object)FileUtils.relativePath((File)serverDir, (File)serverLayout.databasesDirectory()), (Object)FileUtils.relativePath((File)embeddedDir, (File)embeddedLayout.databasesDirectory()));
        Assert.assertEquals((Object)FileUtils.relativePath((File)serverDir, (File)serverLayout.transactionLogsRootDirectory()), (Object)FileUtils.relativePath((File)embeddedDir, (File)embeddedLayout.transactionLogsRootDirectory()));
    }

    protected abstract DatabaseManagementService newEmbeddedDbms(File var1);

    private void testStartupWithConnectors(boolean httpEnabled, boolean httpsEnabled, boolean boltEnabled) throws Exception {
        SslPolicyConfig httpsPolicy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.HTTPS);
        if (httpsEnabled) {
            SelfSignedCertificateFactory.create((File)this.testDirectory.homeDir().getAbsoluteFile());
        }
        Object[] config = new String[]{"-c", httpsEnabled ? this.configOption(httpsPolicy.enabled, "true") : "", "-c", httpsEnabled ? this.configOption(httpsPolicy.base_directory, this.testDirectory.homeDir().getAbsolutePath()) : "", "-c", HttpConnector.enabled.name() + "=" + httpEnabled, "-c", HttpConnector.listen_address.name() + "=localhost:0", "-c", HttpsConnector.enabled.name() + "=" + httpsEnabled, "-c", HttpsConnector.listen_address.name() + "=localhost:0", "-c", BoltConnector.enabled.name() + "=" + boltEnabled, "-c", BoltConnector.listen_address.name() + "=localhost:0"};
        String[] allConfigOptions = (String[])ArrayUtils.addAll((Object[])config, (Object[])this.getAdditionalArguments());
        int resultCode = ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])allConfigOptions);
        Assert.assertEquals((long)0L, (long)resultCode);
        org.neo4j.test.assertion.Assert.assertEventually((String)"Server was not started", () -> ((ServerBootstrapper)this.bootstrapper).isRunning(), (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        this.assertDbAccessibleAsEmbedded();
        ServerTestUtils.verifyConnector((GraphDatabaseService)this.db(), "http", httpEnabled);
        ServerTestUtils.verifyConnector((GraphDatabaseService)this.db(), "https", httpsEnabled);
        ServerTestUtils.verifyConnector((GraphDatabaseService)this.db(), "bolt", boltEnabled);
    }

    protected String configOption(Setting<?> setting, String value) {
        return setting.name() + "=" + value;
    }

    protected static String[] withConnectorsOnRandomPortsConfig(String ... otherConfigs) {
        Stream<String> configs = Stream.of(otherConfigs);
        Stream connectorsConfig = BaseBootstrapperIT.connectorsOnRandomPortsConfig().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).flatMap(config -> Stream.of("-c", config));
        return (String[])Stream.concat(configs, connectorsConfig).toArray(String[]::new);
    }

    protected static Map<String, String> connectorsOnRandomPortsConfig() {
        return MapUtil.stringMap((String[])new String[]{HttpConnector.listen_address.name(), "localhost:0", HttpConnector.enabled.name(), "true", HttpsConnector.listen_address.name(), "localhost:0", HttpsConnector.enabled.name(), "false", BoltConnector.listen_address.name(), "localhost:0", BoltConnector.encryption_level.name(), "DISABLED", BoltConnector.enabled.name(), "true"});
    }

    private void assertDbAccessibleAsEmbedded() {
        GraphDatabaseAPI db = this.db();
        Label label = () -> "Node";
        String propertyKey = "key";
        String propertyValue = "value";
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{label}).setProperty(propertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Node node = (Node)Iterators.single((Iterator)tx.findNodes(label));
            Assert.assertEquals((Object)propertyValue, (Object)node.getProperty(propertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private GraphDatabaseAPI db() {
        return this.bootstrapper.getServer().getDatabaseService().getDatabase();
    }
}

