/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.helpers.Transactor;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerJAXRSIT
extends ExclusiveServerTestBase {
    private NeoServer server;

    @Before
    public void cleanTheDatabase() {
        ServerHelper.cleanTheDatabase(this.server);
    }

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldMakeJAXRSClassesAvailableViaHTTP() throws Exception {
        CommunityServerBuilder serverBuilder = CommunityServerBuilder.server();
        this.server = ServerHelper.createNonPersistentServer(serverBuilder);
        FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper(this.server);
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().build();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpResponse<Void> response = httpClient.send(request, HttpResponse.BodyHandlers.discarding());
        Assert.assertEquals((long)200L, (long)response.statusCode());
    }

    @Test
    public void shouldLoadThirdPartyJaxRsClasses() throws Exception {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withThirdPartyJaxRsPackage("org.dummy.web.service", "/dummy").usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath()).build();
        this.server.start();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        URI thirdPartyServiceUri = new URI(this.server.baseUri() + "/dummy").normalize();
        HttpRequest request = HttpRequest.newBuilder(thirdPartyServiceUri).GET().build();
        String response = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
        Assert.assertEquals((Object)"hello", (Object)response);
        int nodesCreated = NeoServerJAXRSIT.createSimpleDatabase((GraphDatabaseAPI)this.server.getDatabaseService().getDatabase());
        thirdPartyServiceUri = new URI(this.server.baseUri() + "/dummy/inject-test").normalize();
        request = HttpRequest.newBuilder(thirdPartyServiceUri).GET().build();
        response = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
        Assert.assertEquals((String)response, (Object)String.valueOf(nodesCreated), (Object)response);
    }

    private static int createSimpleDatabase(GraphDatabaseAPI graph) {
        int numberOfNodes = 10;
        new Transactor((GraphDatabaseService)graph, tx -> {
            for (int i = 0; i < 10; ++i) {
                tx.createNode();
            }
            for (Node node1 : tx.getAllNodes()) {
                for (Node node2 : tx.getAllNodes()) {
                    if (node1.equals(node2)) continue;
                    node1.createRelationshipTo(node2, RelationshipType.withName((String)"REL"));
                }
            }
        }).execute();
        return 10;
    }
}

