/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class RedirectToBrowserTestIT
extends ExclusiveServerTestBase {
    private static NeoServer server;

    @BeforeClass
    public static void startServer() throws IOException {
        server = ServerHelper.createNonPersistentServer();
    }

    @AfterClass
    public static void stopServer() {
        if (server != null) {
            server.stop();
        }
    }

    @Test
    public void shouldRedirectToBrowser() throws Exception {
        HttpResponse<Void> response = RedirectToBrowserTestIT.sendGetRequest("Accept", "text/html");
        Assert.assertEquals((long)303L, (long)response.statusCode());
        Assert.assertEquals(List.of(server.baseUri() + "browser/"), response.headers().allValues("Location"));
    }

    @Test
    public void shouldRedirectToBrowserUsingXForwardedHeaders() throws Exception {
        HttpResponse<Void> response = RedirectToBrowserTestIT.sendGetRequest("Accept", "text/html", "X-Forwarded-Host", "foo.bar:8734", "X-Forwarded-Proto", "https");
        Assert.assertEquals((long)303L, (long)response.statusCode());
        Assert.assertEquals(List.of("https://foo.bar:8734/browser/"), response.headers().allValues("Location"));
    }

    private static HttpResponse<Void> sendGetRequest(String ... headers) throws Exception {
        HttpRequest request = HttpRequest.newBuilder(server.baseUri()).headers(headers).GET().build();
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
        return client.send(request, HttpResponse.BodyHandlers.discarding());
    }
}

