/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.server.ContainerRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.server.web.XForwardFilter;

class XForwardFilterTest {
    private static final String X_FORWARD_HOST_HEADER_KEY = "X-Forwarded-Host";
    private static final String X_FORWARD_PROTO_HEADER_KEY = "X-Forwarded-Proto";

    XForwardFilterTest() {
    }

    @Test
    void shouldSetTheBaseUriToTheSameValueAsTheXForwardHostHeader() {
        String xForwardHostAndPort = "jimwebber.org:1234";
        XForwardFilter filter = new XForwardFilter();
        Map<String, List<String>> headers = Map.of(X_FORWARD_HOST_HEADER_KEY, List.of(xForwardHostAndPort));
        ContainerRequest request = new ContainerRequest(URI.create("http://iansrobinson.com"), URI.create("http://iansrobinson.com/foo/bar"), "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        request.headers(headers);
        filter.filter((ContainerRequestContext)request);
        MatcherAssert.assertThat((Object)request.getBaseUri().toString(), (Matcher)CoreMatchers.containsString((String)xForwardHostAndPort));
    }

    @Test
    void shouldSetTheRequestUriToTheSameValueAsTheXForwardHostHeader() {
        String xForwardHostAndPort = "jimwebber.org:1234";
        XForwardFilter filter = new XForwardFilter();
        Map<String, List<String>> headers = Map.of(X_FORWARD_HOST_HEADER_KEY, List.of(xForwardHostAndPort));
        ContainerRequest request = new ContainerRequest(URI.create("http://iansrobinson.com"), URI.create("http://iansrobinson.com/foo/bar"), "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        request.headers(headers);
        filter.filter((ContainerRequestContext)request);
        Assertions.assertTrue((boolean)request.getRequestUri().toString().startsWith("http://" + xForwardHostAndPort));
    }

    @Test
    void shouldSetTheBaseUriToTheSameProtocolAsTheXForwardProtoHeader() {
        String theProtocol = "https";
        XForwardFilter filter = new XForwardFilter();
        Map<String, List<String>> headers = Map.of(X_FORWARD_PROTO_HEADER_KEY, List.of(theProtocol));
        ContainerRequest request = new ContainerRequest(URI.create("http://jimwebber.org:1234"), URI.create("http://jimwebber.org:1234/foo/bar"), "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        request.headers(headers);
        filter.filter((ContainerRequestContext)request);
        MatcherAssert.assertThat((Object)request.getBaseUri().getScheme(), (Matcher)CoreMatchers.containsString((String)theProtocol));
    }

    @Test
    void shouldSetTheRequestUriToTheSameProtocolAsTheXForwardProtoHeader() {
        String theProtocol = "https";
        XForwardFilter filter = new XForwardFilter();
        Map<String, List<String>> headers = Map.of(X_FORWARD_PROTO_HEADER_KEY, List.of(theProtocol));
        ContainerRequest request = new ContainerRequest(URI.create("http://jimwebber.org:1234"), URI.create("http://jimwebber.org:1234/foo/bar"), "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        request.headers(headers);
        filter.filter((ContainerRequestContext)request);
        MatcherAssert.assertThat((Object)request.getBaseUri().getScheme(), (Matcher)CoreMatchers.containsString((String)theProtocol));
    }
}

