/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.bind;

import java.net.URI;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.server.bind.ComponentsBinder;
import org.neo4j.server.bind.DummyComponent;
import org.neo4j.server.bind.DummyComponentSupplier;
import org.neo4j.server.bind.DummyRestResource;
import org.neo4j.server.bind.MemorizingContainerResponseWriter;

class ComponentsBinderTest {
    private final ComponentsBinder binder = new ComponentsBinder();

    ComponentsBinderTest() {
    }

    @Test
    void shouldConfigureSingletonDependencyInjection() {
        this.configureSingletonInjection();
        this.testDependencyInjectionConfiguration();
    }

    @Test
    void shouldConfigureSupplierDependencyInjection() {
        this.configureSupplierInjection();
        this.testDependencyInjectionConfiguration();
    }

    @Test
    void shouldConfigureSupplierClassDependencyInjection() {
        this.configureSupplierClassInjection();
        this.testDependencyInjectionConfiguration();
    }

    @Test
    void shouldThrowWhenDependencyInjectionConfiguredAfterStartup() {
        this.configureSingletonInjection();
        this.testDependencyInjectionConfiguration();
        Assertions.assertThrows(IllegalStateException.class, this::configureSingletonInjection);
        Assertions.assertThrows(IllegalStateException.class, this::configureSingletonInjection);
        Assertions.assertThrows(IllegalStateException.class, this::configureSupplierClassInjection);
    }

    private void configureSingletonInjection() {
        this.binder.addSingletonBinding((Object)new DummyComponent(), DummyComponent.class);
    }

    private void configureSupplierInjection() {
        this.binder.addLazyBinding(DummyComponent::new, DummyComponent.class);
    }

    private void configureSupplierClassInjection() {
        this.binder.addLazyBinding(DummyComponentSupplier.class, DummyComponent.class);
    }

    private void testDependencyInjectionConfiguration() {
        ResourceConfig resourceConfig = new ResourceConfig().register((Object)this.binder).register(DummyRestResource.class);
        ApplicationHandler handler = new ApplicationHandler((Application)resourceConfig);
        ContainerRequest request = new ContainerRequest(URI.create("http://neo4j.com/"), URI.create("http://neo4j.com/"), "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        MemorizingContainerResponseWriter responseWriter = new MemorizingContainerResponseWriter();
        request.setWriter((ContainerResponseWriter)responseWriter);
        handler.handle(request);
        Assertions.assertEquals((Object)Response.Status.OK, (Object)responseWriter.getStatus());
        Assertions.assertEquals((Object)"42", (Object)responseWriter.getEntity());
    }
}

