/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ConfigFileBuilder;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.test.rule.SuppressOutput;

public class ConfigLoaderTest {
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void shouldProvideAConfiguration() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void shouldUseSpecifiedConfigFile() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        String EXPECTED_VALUE = "bar";
        Assert.assertEquals((Object)"bar", (Object)((SocketAddress)testConf.get(GraphDatabaseSettings.default_advertised_address)).toString());
    }

    @Test
    public void shouldUseSpecifiedHomeDir() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        Assert.assertEquals((Object)this.folder.getRoot().getAbsolutePath(), (Object)((Path)testConf.get(GraphDatabaseSettings.neo4j_home)).toString());
    }

    @Test
    public void shouldUseWorkingDirForHomeDirIfUnspecified() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).build();
        Config testConf = Config.newBuilder().fromFile(configFile).build();
        Assert.assertEquals((Object)new File(System.getProperty("user.dir")).getAbsolutePath(), (Object)((Path)testConf.get(GraphDatabaseSettings.neo4j_home)).toString());
    }

    @Test
    public void shouldAcceptDuplicateKeysWithSameValue() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        Assert.assertNotNull((Object)testConf);
        String EXPECTED_VALUE = "bar";
        Assert.assertEquals((Object)"bar", (Object)((SocketAddress)testConf.get(GraphDatabaseSettings.default_advertised_address)).toString());
    }

    @Test
    public void loadOfflineConfigShouldDisableBolt() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withNameValue(BoltConnector.enabled.name(), "true").build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        ConfigUtils.disableAllConnectors((Config)testConf);
        Assert.assertNotNull((Object)testConf);
        Assert.assertEquals((Object)false, (Object)testConf.get(BoltConnector.enabled));
    }

    @Test
    public void loadOfflineConfigAddDisabledBoltConnector() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        ConfigUtils.disableAllConnectors((Config)testConf);
        Assert.assertNotNull((Object)testConf);
        Assert.assertEquals((Object)false, (Object)testConf.get(BoltConnector.enabled));
    }

    @Test
    public void shouldFindThirdPartyJaxRsPackages() throws IOException {
        File file = ServerTestUtils.createTempConfigFile(this.folder.getRoot());
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file, true));){
            out.write(ServerSettings.third_party_packages.name());
            out.write("=");
            out.write("com.foo.bar=\"mount/point/foo\",");
            out.write("com.foo.baz=\"/bar\",");
            out.write("com.foo.foobarbaz=\"/\"");
            out.write(System.lineSeparator());
        }
        Config config = Config.newBuilder().fromFile(file).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        List thirdpartyJaxRsPackages = (List)config.get(ServerSettings.third_party_packages);
        Assert.assertNotNull((Object)thirdpartyJaxRsPackages);
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
    }

    @Test
    public void shouldRetainRegistrationOrderOfThirdPartyJaxRsPackages() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withNameValue(ServerSettings.third_party_packages.name(), "org.neo4j.extension.extension1=/extension1,org.neo4j.extension.extension2=/extension2,org.neo4j.extension.extension3=/extension3").build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        List thirdpartyJaxRsPackages = (List)config.get(ServerSettings.third_party_packages);
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
        Assert.assertEquals((Object)"/extension1", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(0)).getMountPoint());
        Assert.assertEquals((Object)"/extension2", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(1)).getMountPoint());
        Assert.assertEquals((Object)"/extension3", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(2)).getMountPoint());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenSpecifiedConfigFileDoesNotExist() {
        File nonExistentConfigFile = new File("/tmp/" + System.currentTimeMillis());
        Config config = Config.newBuilder().fromFile(nonExistentConfigFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void shouldWorkFineWhenSpecifiedConfigFileDoesNotExist() {
        File nonExistentConfigFile = new File("/tmp/" + System.currentTimeMillis());
        Config config = Config.newBuilder().fromFileNoThrow(nonExistentConfigFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void shouldDefaultToCorrectValueForAuthStoreLocation() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withoutSetting(GraphDatabaseSettings.data_directory).build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        Assert.assertThat((Object)((Path)config.get(DatabaseManagementSystemSettings.auth_store_directory)), (Matcher)Matchers.is((Object)new File(this.folder.getRoot(), "data/dbms").getAbsoluteFile().toPath()));
    }

    @Test
    public void shouldSetAValueForAuthStoreLocation() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withSetting(GraphDatabaseSettings.data_directory, "the-data-dir").build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        Assert.assertThat((Object)((Path)config.get(DatabaseManagementSystemSettings.auth_store_directory)), (Matcher)Matchers.is((Object)new File(this.folder.getRoot(), "the-data-dir/dbms").getAbsoluteFile().toPath()));
    }

    @Test
    public void shouldNotOverwriteAuthStoreLocationIfProvided() {
        File configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withSetting(GraphDatabaseSettings.data_directory, "the-data-dir").withSetting(GraphDatabaseSettings.auth_store, "foo/bar/auth").build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.folder.getRoot().toPath()).build();
        Assert.assertThat((Object)((Path)config.get(GraphDatabaseSettings.auth_store)), (Matcher)Matchers.is((Object)new File(this.folder.getRoot(), "foo/bar/auth").getAbsoluteFile().toPath()));
    }
}

