/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.CommunityGraphFactory;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.database.InMemoryGraphFactory;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

public class CommunityServerBuilder {
    private static final SocketAddress ANY_ADDRESS = new SocketAddress("localhost", 0);
    protected final LogProvider logProvider;
    private SocketAddress address = new SocketAddress("localhost", 7474);
    private SocketAddress httpsAddress = new SocketAddress("localhost", 7473);
    private String maxThreads;
    private String dataDir;
    private String dbUri = "/db";
    private String restUri = "/db/data";
    private PreFlightTasks preflightTasks;
    private final HashMap<String, String> thirdPartyPackages = new HashMap();
    private final Properties arbitraryProperties = new Properties();
    private boolean persistent;
    private boolean httpEnabled = true;
    private boolean httpsEnabled;
    private GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies();
    private Consumer<WebServer> afterWebServerStart;

    public static CommunityServerBuilder server(LogProvider logProvider) {
        return new CommunityServerBuilder(logProvider);
    }

    public static CommunityServerBuilder server() {
        return new CommunityServerBuilder((LogProvider)NullLogProvider.getInstance());
    }

    public static CommunityServerBuilder serverOnRandomPorts() {
        return CommunityServerBuilder.server().onRandomPorts();
    }

    public CommunityNeoServer build() throws IOException {
        if (this.dataDir == null && this.persistent) {
            throw new IllegalStateException("Must specify path");
        }
        File configFile = this.buildBefore();
        Log log = this.logProvider.getLog(this.getClass());
        Config config = Config.newBuilder().setDefaults(GraphDatabaseSettings.SERVER_DEFAULTS).fromFile(configFile).build();
        config.setLogger(log);
        GraphDatabaseDependencies dependencies = this.dependencies.userLogProvider(this.logProvider).monitors(new Monitors());
        return this.build(configFile, config, (ExternalDependencies)dependencies);
    }

    protected CommunityNeoServer build(File configFile, Config config, ExternalDependencies dependencies) {
        return new TestCommunityNeoServer(config, configFile, dependencies, this.afterWebServerStart);
    }

    public File createConfigFiles() throws IOException {
        File testFolder = this.persistent ? new File(this.dataDir) : ServerTestUtils.createTempDir();
        File temporaryConfigFile = ServerTestUtils.createTempConfigFile(testFolder);
        ServerTestUtils.writeConfigToFile(this.createConfiguration(testFolder), temporaryConfigFile);
        return temporaryConfigFile;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Map<String, String> createConfiguration(File temporaryFolder) {
        Map properties = MapUtil.stringMap((String[])new String[]{ServerSettings.db_api_path.name(), this.dbUri, ServerSettings.rest_api_path.name(), this.restUri});
        ServerTestUtils.addDefaultRelativeProperties(properties, temporaryFolder);
        if (this.dataDir != null) {
            properties.put(GraphDatabaseSettings.data_directory.name(), this.dataDir);
        }
        if (this.maxThreads != null) {
            properties.put(ServerSettings.webserver_max_threads.name(), this.maxThreads);
        }
        if (this.thirdPartyPackages.keySet().size() > 0) {
            properties.put(ServerSettings.third_party_packages.name(), ServerTestUtils.asOneLine(this.thirdPartyPackages));
        }
        properties.put(HttpConnector.enabled.name(), String.valueOf(this.httpEnabled));
        properties.put(HttpConnector.listen_address.name(), this.address.toString());
        properties.put(HttpsConnector.enabled.name(), String.valueOf(this.httpsEnabled));
        properties.put(HttpsConnector.listen_address.name(), this.httpsAddress.toString());
        properties.put(GraphDatabaseSettings.neo4j_home.name(), temporaryFolder.getAbsolutePath());
        properties.put(GraphDatabaseSettings.auth_enabled.name(), "false");
        if (this.httpsEnabled) {
            File certificates = new File(temporaryFolder, "certificates");
            SelfSignedCertificateFactory.create((File)certificates);
            SslPolicyConfig policy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.HTTPS);
            properties.put(policy.enabled.name(), Boolean.TRUE.toString());
            properties.put(policy.base_directory.name(), certificates.getAbsolutePath());
            properties.put(policy.trust_all.name(), "true");
            properties.put(policy.client_auth.name(), ClientAuth.NONE.name());
        }
        properties.put(GraphDatabaseSettings.logs_directory.name(), new File(temporaryFolder, "logs").getAbsolutePath());
        properties.put(GraphDatabaseSettings.transaction_logs_root_path.name(), new File(temporaryFolder, "transaction-logs").getAbsolutePath());
        properties.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        properties.put(GraphDatabaseSettings.shutdown_transaction_end_timeout.name(), "0s");
        for (Object key : this.arbitraryProperties.keySet()) {
            properties.put(String.valueOf(key), String.valueOf(this.arbitraryProperties.get(key)));
        }
        return properties;
    }

    protected CommunityServerBuilder(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public CommunityServerBuilder withDependencies(DependencyResolver dependencyResolver) {
        this.dependencies = this.dependencies.dependencies(dependencyResolver);
        return this;
    }

    public CommunityServerBuilder persistent() {
        this.persistent = true;
        return this;
    }

    public CommunityServerBuilder withMaxJettyThreads(int maxThreads) {
        this.maxThreads = String.valueOf(maxThreads);
        return this;
    }

    public CommunityServerBuilder usingDataDir(String dataDir) {
        this.dataDir = dataDir;
        return this;
    }

    public CommunityServerBuilder withRelativeDatabaseApiPath(String uri) {
        this.dbUri = CommunityServerBuilder.getPath(uri);
        return this;
    }

    public CommunityServerBuilder withRelativeRestApiPath(String uri) {
        this.restUri = CommunityServerBuilder.getPath(uri);
        return this;
    }

    public CommunityServerBuilder withDefaultDatabaseTuning() {
        return this;
    }

    public CommunityServerBuilder withThirdPartyJaxRsPackage(String packageName, String mountPoint) {
        this.thirdPartyPackages.put(packageName, mountPoint);
        return this;
    }

    public CommunityServerBuilder onRandomPorts() {
        this.onHttpsAddress(ANY_ADDRESS);
        this.onAddress(ANY_ADDRESS);
        return this;
    }

    public CommunityServerBuilder onAddress(SocketAddress address) {
        this.address = address;
        return this;
    }

    public CommunityServerBuilder onHttpsAddress(SocketAddress address) {
        this.httpsAddress = address;
        return this;
    }

    public CommunityServerBuilder withHttpsEnabled() {
        this.httpsEnabled = true;
        return this;
    }

    public CommunityServerBuilder withHttpDisabled() {
        this.httpEnabled = false;
        return this;
    }

    public CommunityServerBuilder withProperty(String key, String value) {
        this.arbitraryProperties.put(key, value);
        return this;
    }

    public CommunityServerBuilder withAfterWebServerStartCallback(Consumer<WebServer> callback) {
        this.afterWebServerStart = callback;
        return this;
    }

    private static String getPath(String uri) {
        URI theUri = URI.create(uri);
        if (theUri.isAbsolute()) {
            return theUri.getPath();
        }
        return theUri.toString();
    }

    private File buildBefore() throws IOException {
        File configFile = this.createConfigFiles();
        if (this.preflightTasks == null) {
            this.preflightTasks = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), new PreflightTask[0]){

                public boolean run() {
                    return true;
                }
            };
        }
        return configFile;
    }

    static {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    private class TestCommunityNeoServer
    extends CommunityNeoServer {
        private final File configFile;
        private final Consumer<WebServer> afterWebServerStart;

        private TestCommunityNeoServer(Config config, File configFile, ExternalDependencies dependencies, Consumer<WebServer> afterWebServerStart) {
            super(config, (GraphFactory)(CommunityServerBuilder.this.persistent ? new CommunityGraphFactory() : new InMemoryGraphFactory()), dependencies);
            this.configFile = configFile;
            this.afterWebServerStart = afterWebServerStart;
        }

        protected WebServer createWebServer() {
            WebServer webServer = super.createWebServer();
            if (this.afterWebServerStart != null) {
                this.afterWebServerStart.accept(webServer);
            }
            return webServer;
        }

        public void stop() {
            super.stop();
            if (this.configFile != null) {
                this.configFile.delete();
            }
        }
    }
}

