/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.database.DatabaseService;
import org.neo4j.server.http.cypher.HttpTransactionManager;
import org.neo4j.time.Clocks;

public class HttpTransactionManagerTest {
    @Test
    public void shouldSetupJobScheduler() {
        DatabaseService database = (DatabaseService)Mockito.mock(DatabaseService.class);
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        new HttpTransactionManager(database, jobScheduler, Clocks.systemClock(), Duration.ofMinutes(1L), (LogProvider)logProvider);
        long runEvery = Math.round((double)Duration.ofMinutes(1L).toMillis() / 2.0);
        ((JobScheduler)Mockito.verify((Object)jobScheduler)).scheduleRecurring((Group)ArgumentMatchers.eq((Object)Group.SERVER_TRANSACTION_TIMEOUT), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.eq((long)runEvery), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void shouldCreateTransactionHandleRegistry() {
        DatabaseService database = (DatabaseService)Mockito.mock(DatabaseService.class);
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        HttpTransactionManager manager = new HttpTransactionManager(database, jobScheduler, Clocks.systemClock(), Duration.ofMinutes(1L), (LogProvider)logProvider);
        Assert.assertNotNull((Object)manager.getTransactionHandleRegistry());
    }

    @Test
    public void shouldGetEmptyTransactionFacadeOfDatabaseData() {
        DatabaseService database = (DatabaseService)Mockito.mock(DatabaseService.class);
        HttpTransactionManager manager = this.newTransactionManager(database);
        Optional graphDatabaseFacade = manager.getGraphDatabaseFacade("data");
        Assert.assertFalse((boolean)graphDatabaseFacade.isPresent());
        ((DatabaseService)Mockito.verify((Object)database)).getDatabase("data");
    }

    @Test
    public void shouldGetTransactionFacadeOfDatabaseWithSpecifiedName() {
        DatabaseService database = (DatabaseService)Mockito.mock(DatabaseService.class);
        HttpTransactionManager manager = this.newTransactionManager(database);
        Optional transactionFacade = manager.getGraphDatabaseFacade("neo4j");
        Assert.assertTrue((boolean)transactionFacade.isPresent());
        ((DatabaseService)Mockito.verify((Object)database)).getDatabase("neo4j");
    }

    @Test
    public void shouldGetEmptyTransactionFacadeForUnknownDatabase() {
        DatabaseService database = (DatabaseService)Mockito.mock(DatabaseService.class);
        HttpTransactionManager manager = this.newTransactionManager(database);
        Optional transactionFacade = manager.getGraphDatabaseFacade("foo");
        Assert.assertFalse((boolean)transactionFacade.isPresent());
        ((DatabaseService)Mockito.verify((Object)database)).getDatabase("foo");
    }

    private HttpTransactionManager newTransactionManager(DatabaseService database) {
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        String defaultDatabase = "neo4j";
        Mockito.when((Object)database.getDatabase((String)ArgumentMatchers.any(String.class))).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            String db = (String)args[0];
            if (db.equals(defaultDatabase) || db.equals("system")) {
                return this.graphWithName(db);
            }
            throw new DatabaseNotFoundException("Not found db named " + db);
        });
        return new HttpTransactionManager(database, jobScheduler, Clocks.systemClock(), Duration.ofMinutes(1L), (LogProvider)logProvider);
    }

    private GraphDatabaseFacade graphWithName(String name) {
        GraphDatabaseFacade graph = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
        Mockito.when((Object)graph.databaseName()).thenReturn((Object)name);
        Mockito.when((Object)graph.getDependencyResolver()).thenReturn((Object)((DependencyResolver)Mockito.mock(DependencyResolver.class, (Answer)Answers.RETURNS_SMART_NULLS)));
        return graph;
    }
}

