/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.impl.notification.NotificationCode;
import org.neo4j.graphdb.impl.notification.NotificationDetail;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.http.cypher.format.api.FailureEvent;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.api.StatementEndEvent;
import org.neo4j.server.http.cypher.format.api.StatementStartEvent;
import org.neo4j.server.http.cypher.format.api.TransactionInfoEvent;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.output.json.ExecutionResultSerializer;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContent;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.Property;
import org.neo4j.test.mockito.mock.GraphMock;
import org.neo4j.test.mockito.mock.Link;
import org.neo4j.test.mockito.mock.Properties;
import org.neo4j.test.mockito.mock.SpatialMocks;

class ExecutionResultSerializerTest {
    private static final Map<String, Object> NO_ARGS = Collections.emptyMap();
    private static final Set<String> NO_IDS = Collections.emptySet();
    private static final List<ExecutionPlanDescription> NO_PLANS = Collections.emptyList();
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private ExecutionResultSerializer serializer;
    private final TransactionHandle transactionHandle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
    private InternalTransaction internalTransaction;

    ExecutionResultSerializerTest() {
    }

    @BeforeEach
    void init() {
        TransitionalTxManagementKernelTransaction context = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
        this.internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        KernelTransactionImplementation kernelTransaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)this.internalTransaction.kernelTransaction()).thenReturn((Object)kernelTransaction);
        Mockito.when((Object)context.getInternalTransaction()).thenReturn((Object)this.internalTransaction);
        Mockito.when((Object)this.transactionHandle.getContext()).thenReturn((Object)context);
        this.serializer = this.getSerializerWith(this.output);
    }

    @Test
    void shouldSerializeResponseWithCommitUriOnly() throws Exception {
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create("commit/uri/1"), -1L));
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithCommitUriAndResults() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("column1", "value1");
        row.put("column2", "value2");
        this.writeStatementStart("column1", "column2");
        this.writeRecord(row, "column1", "column2");
        this.writeStatementEnd();
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create("commit/uri/1"), -1L));
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithResultsOnly() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("column1", "value1");
        row.put("column2", "value2");
        this.writeStatementStart("column1", "column2");
        this.writeRecord(row, "column1", "column2");
        this.writeStatementEnd();
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithCommitUriAndResultsAndErrors() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("column1", "value1");
        row.put("column2", "value2");
        this.writeStatementStart("column1", "column2");
        this.writeRecord(row, "column1", "column2");
        this.writeStatementEnd();
        this.writeError((Status)Status.Request.InvalidFormat, "cause1");
        this.writeTransactionInfo("commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithResultsAndErrors() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("column1", "value1");
        row.put("column2", "value2");
        this.writeStatementStart("column1", "column2");
        this.writeRecord(row, "column1", "column2");
        this.writeStatementEnd();
        this.writeError((Status)Status.Request.InvalidFormat, "cause1");
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}]}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithCommitUriAndErrors() throws Exception {
        this.writeError((Status)Status.Request.InvalidFormat, "cause1");
        this.writeTransactionInfo("commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithErrorsOnly() throws Exception {
        this.writeError((Status)Status.Request.InvalidFormat, "cause1");
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}]}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithNoCommitUriResultsOrErrors() throws Exception {
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithMultipleResultRows() throws Exception {
        HashMap<String, Object> row1 = new HashMap<String, Object>();
        row1.put("column1", "value1");
        row1.put("column2", "value2");
        HashMap<String, Object> row2 = new HashMap<String, Object>();
        row2.put("column1", "value3");
        row2.put("column2", "value4");
        this.writeStatementStart("column1", "column2");
        this.writeRecord(row1, "column1", "column2");
        this.writeRecord(row2, "column1", "column2");
        this.writeStatementEnd();
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]},{\"row\":[\"value3\",\"value4\"],\"meta\":[null,null]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithMultipleResults() throws Exception {
        HashMap<String, Object> row1 = new HashMap<String, Object>();
        row1.put("column1", "value1");
        row1.put("column2", "value2");
        HashMap<String, Object> row2 = new HashMap<String, Object>();
        row2.put("column3", "value3");
        row2.put("column4", "value4");
        this.writeStatementStart("column1", "column2");
        this.writeRecord(row1, "column1", "column2");
        this.writeStatementEnd();
        this.writeStatementStart("column3", "column4");
        this.writeRecord(row2, "column3", "column4");
        this.writeStatementEnd();
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]},{\"columns\":[\"column3\",\"column4\"],\"data\":[{\"row\":[\"value3\",\"value4\"],\"meta\":[null,null]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeNodeAsMapOfProperties() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        Node node = GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"a", (Object)12), Property.property((String)"b", (Object)true), Property.property((String)"c", (Object)new int[]{1, 0, 1, 2}), Property.property((String)"d", (Object)new byte[]{1, 0, 1, 2}), Property.property((String)"e", (Object)new String[]{"a", "b", "\u00e4\u00e4\u00f6"})}), (String[])new String[0]);
        row.put("node", node);
        Mockito.when((Object)this.internalTransaction.getNodeById(1L)).thenReturn((Object)node);
        this.writeStatementStart("node");
        this.writeRecord(row, "node");
        this.writeStatementEnd();
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"node\"],\"data\":[{\"row\":[{\"a\":12,\"b\":true,\"c\":[1,0,1,2],\"d\":[1,0,1,2],\"e\":[\"a\",\"b\",\"\u00e4\u00e4\u00f6\"]}],\"meta\":[{\"id\":1,\"type\":\"node\",\"deleted\":false}]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeNestedEntities() throws Exception {
        Node a = GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"foo", (Object)12)}), (String[])new String[0]);
        Node b = GraphMock.node((long)2L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"bar", (Object)false)}), (String[])new String[0]);
        Relationship r = GraphMock.relationship((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"baz", (Object)"quux")}), (Node)a, (String)"FRAZZLE", (Node)b);
        Mockito.when((Object)this.internalTransaction.getRelationshipById(1L)).thenReturn((Object)r);
        Mockito.when((Object)this.internalTransaction.getNodeById(1L)).thenReturn((Object)a);
        Mockito.when((Object)this.internalTransaction.getNodeById(2L)).thenReturn((Object)b);
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("nested", new TreeMap(MapUtil.map((Object[])new Object[]{"node", a, "edge", r, "path", GraphMock.path((Node)a, (Link[])new Link[]{GraphMock.link((Relationship)r, (Node)b)})})));
        this.writeStatementStart("nested");
        this.writeRecord(row, "nested");
        this.writeStatementEnd();
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"nested\"],\"data\":[{\"row\":[{\"edge\":{\"baz\":\"quux\"},\"node\":{\"foo\":12},\"path\":[{\"foo\":12},{\"baz\":\"quux\"},{\"bar\":false}]}],\"meta\":[{\"id\":1,\"type\":\"relationship\",\"deleted\":false},{\"id\":1,\"type\":\"node\",\"deleted\":false},[{\"id\":1,\"type\":\"node\",\"deleted\":false},{\"id\":1,\"type\":\"relationship\",\"deleted\":false},{\"id\":2,\"type\":\"node\",\"deleted\":false}]]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializePathAsListOfMapsOfProperties() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        Path path = ExecutionResultSerializerTest.mockPath(MapUtil.map((Object[])new Object[]{"key1", "value1"}), MapUtil.map((Object[])new Object[]{"key2", "value2"}), MapUtil.map((Object[])new Object[]{"key3", "value3"}));
        row.put("path", path);
        Node startNode = path.startNode();
        Node endNode = path.endNode();
        Relationship rel = path.lastRelationship();
        Mockito.when((Object)this.internalTransaction.getRelationshipById(1L)).thenReturn((Object)rel);
        Mockito.when((Object)this.internalTransaction.getNodeById(1L)).thenReturn((Object)startNode);
        Mockito.when((Object)this.internalTransaction.getNodeById(2L)).thenReturn((Object)endNode);
        this.writeStatementStart("path");
        this.writeRecord(row, "path");
        this.writeStatementEnd();
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"path\"],\"data\":[{\"row\":[[{\"key1\":\"value1\"},{\"key2\":\"value2\"},{\"key3\":\"value3\"}]],\"meta\":[[{\"id\":1,\"type\":\"node\",\"deleted\":false},{\"id\":1,\"type\":\"relationship\",\"deleted\":false},{\"id\":2,\"type\":\"node\",\"deleted\":false}]]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializePointsAsListOfMapsOfProperties() throws Exception {
        HashMap<String, Object> row1 = new HashMap<String, Object>();
        row1.put("geom", SpatialMocks.mockPoint((double)12.3, (double)45.6, (CRS)SpatialMocks.mockWGS84()));
        HashMap<String, Object> row2 = new HashMap<String, Object>();
        row2.put("geom", SpatialMocks.mockPoint((double)123.0, (double)456.0, (CRS)SpatialMocks.mockCartesian()));
        HashMap<String, Object> row3 = new HashMap<String, Object>();
        row3.put("geom", SpatialMocks.mockPoint((double)12.3, (double)45.6, (double)78.9, (CRS)SpatialMocks.mockWGS84_3D()));
        HashMap<String, Object> row4 = new HashMap<String, Object>();
        row4.put("geom", SpatialMocks.mockPoint((double)123.0, (double)456.0, (double)789.0, (CRS)SpatialMocks.mockCartesian_3D()));
        this.writeStatementStart("geom");
        this.writeRecord(row1, "geom");
        this.writeRecord(row2, "geom");
        this.writeRecord(row3, "geom");
        this.writeRecord(row4, "geom");
        this.writeStatementEnd();
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"geom\"],\"data\":[{\"row\":[{\"type\":\"Point\",\"coordinates\":[12.3,45.6],\"crs\":{\"srid\":4326,\"name\":\"WGS-84\",\"type\":\"link\",\"properties\":{\"href\":\"http://spatialreference.org/ref/epsg/4326/ogcwkt/\",\"type\":\"ogcwkt\"}}}],\"meta\":[{\"type\":\"point\"}]},{\"row\":[{\"type\":\"Point\",\"coordinates\":[123.0,456.0],\"crs\":{\"srid\":7203,\"name\":\"cartesian\",\"type\":\"link\",\"properties\":{\"href\":\"http://spatialreference.org/ref/sr-org/7203/ogcwkt/\",\"type\":\"ogcwkt\"}}}],\"meta\":[{\"type\":\"point\"}]},{\"row\":[{\"type\":\"Point\",\"coordinates\":[12.3,45.6,78.9],\"crs\":{\"srid\":4979,\"name\":\"WGS-84-3D\",\"type\":\"link\",\"properties\":{\"href\":\"http://spatialreference.org/ref/epsg/4979/ogcwkt/\",\"type\":\"ogcwkt\"}}}],\"meta\":[{\"type\":\"point\"}]},{\"row\":[{\"type\":\"Point\",\"coordinates\":[123.0,456.0,789.0],\"crs\":{\"srid\":9157,\"name\":\"cartesian-3D\",\"type\":\"link\",\"properties\":{\"href\":\"http://spatialreference.org/ref/sr-org/9157/ogcwkt/\",\"type\":\"ogcwkt\"}}}],\"meta\":[{\"type\":\"point\"}]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeTemporalAsListOfMapsOfProperties() throws Exception {
        HashMap<String, Object> row1 = new HashMap<String, Object>();
        row1.put("temporal", LocalDate.of(2018, 3, 12));
        HashMap<String, Object> row2 = new HashMap<String, Object>();
        row2.put("temporal", ZonedDateTime.of(2018, 3, 12, 13, 2, 10, 10, ZoneId.of("UTC+1")));
        HashMap<String, Object> row3 = new HashMap<String, Object>();
        row3.put("temporal", OffsetTime.of(12, 2, 4, 71, ZoneOffset.UTC));
        HashMap<String, Object> row4 = new HashMap<String, Object>();
        row4.put("temporal", LocalDateTime.of(2018, 3, 12, 13, 2, 10, 10));
        HashMap<String, Object> row5 = new HashMap<String, Object>();
        row5.put("temporal", LocalTime.of(13, 2, 10, 10));
        HashMap<String, Object> row6 = new HashMap<String, Object>();
        row6.put("temporal", Duration.of(12L, ChronoUnit.HOURS));
        this.writeStatementStart("temporal");
        this.writeRecord(row1, "temporal");
        this.writeRecord(row2, "temporal");
        this.writeRecord(row3, "temporal");
        this.writeRecord(row4, "temporal");
        this.writeRecord(row5, "temporal");
        this.writeRecord(row6, "temporal");
        this.writeStatementEnd();
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, null, -1L));
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"temporal\"],\"data\":[{\"row\":[\"2018-03-12\"],\"meta\":[{\"type\":\"date\"}]},{\"row\":[\"2018-03-12T13:02:10.000000010+01:00[UTC+01:00]\"],\"meta\":[{\"type\":\"datetime\"}]},{\"row\":[\"12:02:04.000000071Z\"],\"meta\":[{\"type\":\"time\"}]},{\"row\":[\"2018-03-12T13:02:10.000000010\"],\"meta\":[{\"type\":\"localdatetime\"}]},{\"row\":[\"13:02:10.000000010\"],\"meta\":[{\"type\":\"localtime\"}]},{\"row\":[\"PT12H\"],\"meta\":[{\"type\":\"duration\"}]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldErrorWhenSerializingUnknownGeometryType() throws Exception {
        ArrayList<Coordinate> points = new ArrayList<Coordinate>();
        points.add(new Coordinate(new double[]{1.0, 2.0}));
        points.add(new Coordinate(new double[]{2.0, 3.0}));
        HashMap<String, SpatialMocks.MockGeometry> row = new HashMap<String, SpatialMocks.MockGeometry>();
        row.put("geom", SpatialMocks.mockGeometry((String)"LineString", points, (CRS)SpatialMocks.mockCartesian()));
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            this.writeStatementStart("geom");
            this.writeRecord(row, "geom");
        });
        this.writeError((Status)Status.Statement.ExecutionFailed, e.getMessage());
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.startsWith((String)"{\"results\":[{\"columns\":[\"geom\"],\"data\":[{\"row\":[{\"type\":\"LineString\",\"coordinates\":[[1.0,2.0],[2.0,3.0]],\"crs\":{\"srid\":7203,\"name\":\"cartesian\",\"type\":\"link\",\"properties\":{\"href\":\"http://spatialreference.org/ref/sr-org/7203/ogcwkt/\",\"type\":\"ogcwkt\"}}}],\"meta\":[]}]}],\"errors\":[{\"code\":\"Neo.DatabaseError.Statement.ExecutionFailed\",\"message\":\"Unsupported Geometry type: type=MockGeometry, value=LineString\""));
    }

    @Test
    void shouldProduceWellFormedJsonEvenIfResultIteratorThrowsExceptionOnNext() throws Exception {
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("column1", "value1");
        row.put("column2", "value2");
        RecordEvent recordEvent = (RecordEvent)Mockito.mock(RecordEvent.class);
        Mockito.when((Object)recordEvent.getValue((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("Stuff went wrong!")});
        Mockito.when((Object)recordEvent.getColumns()).thenReturn(Arrays.asList("column1", "column2"));
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            this.writeStatementStart("column1", "column2");
            this.writeRecord(row, "column1", "column2");
            this.serializer.writeRecord(recordEvent);
        });
        this.writeError((Status)Status.Statement.ExecutionFailed, e.getMessage());
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]},{\"row\":[],\"meta\":[]}]}],\"errors\":[{\"code\":\"Neo.DatabaseError.Statement.ExecutionFailed\",\"message\":\"Stuff went wrong!\"}]}", (Object)result);
    }

    @Test
    void shouldProduceResultStreamWithGraphEntries() throws Exception {
        Node[] node = new Node[]{GraphMock.node((long)0L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node0")}), (String[])new String[]{"Node"}), GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node1")}), (String[])new String[0]), GraphMock.node((long)2L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node2")}), (String[])new String[]{"This", "That"}), GraphMock.node((long)3L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node3")}), (String[])new String[]{"Other"})};
        Relationship[] rel = new Relationship[]{GraphMock.relationship((long)0L, (Node)node[0], (String)"KNOWS", (Node)node[1], (Property[])new Property[]{Property.property((String)"name", (Object)"rel0")}), GraphMock.relationship((long)1L, (Node)node[2], (String)"LOVES", (Node)node[3], (Property[])new Property[]{Property.property((String)"name", (Object)"rel1")})};
        Mockito.when((Object)this.internalTransaction.getRelationshipById(ArgumentMatchers.anyLong())).thenAnswer(invocation -> rel[((Number)invocation.getArgument(0, Number.class)).intValue()]);
        Mockito.when((Object)this.internalTransaction.getNodeById(ArgumentMatchers.anyLong())).thenAnswer(invocation -> node[((Number)invocation.getArgument(0, Number.class)).intValue()]);
        HashMap<String, Object> resultRow1 = new HashMap<String, Object>();
        resultRow1.put("node", node[0]);
        resultRow1.put("rel", rel[0]);
        HashMap<String, Object> resultRow2 = new HashMap<String, Object>();
        resultRow2.put("node", node[2]);
        resultRow2.put("rel", rel[1]);
        this.writeStatementStart(Arrays.asList(ResultDataContent.row, ResultDataContent.graph), "node", "rel");
        this.writeRecord(resultRow1, "node", "rel");
        this.writeRecord(resultRow2, "node", "rel");
        this.writeStatementEnd();
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        String node0 = "{\"id\":\"0\",\"labels\":[\"Node\"],\"properties\":{\"name\":\"node0\"}}";
        String node1 = "{\"id\":\"1\",\"labels\":[],\"properties\":{\"name\":\"node1\"}}";
        String node2 = "{\"id\":\"2\",\"labels\":[\"This\",\"That\"],\"properties\":{\"name\":\"node2\"}}";
        String node3 = "{\"id\":\"3\",\"labels\":[\"Other\"],\"properties\":{\"name\":\"node3\"}}";
        String rel0 = "\"relationships\":[{\"id\":\"0\",\"type\":\"KNOWS\",\"startNode\":\"0\",\"endNode\":\"1\",\"properties\":{\"name\":\"rel0\"}}]}";
        String rel1 = "\"relationships\":[{\"id\":\"1\",\"type\":\"LOVES\",\"startNode\":\"2\",\"endNode\":\"3\",\"properties\":{\"name\":\"rel1\"}}]}";
        String row0 = "{\"row\":[{\"name\":\"node0\"},{\"name\":\"rel0\"}],\"meta\":[{\"id\":0,\"type\":\"node\",\"deleted\":false},{\"id\":0,\"type\":\"relationship\",\"deleted\":false}],\"graph\":{\"nodes\":[";
        String row1 = "{\"row\":[{\"name\":\"node2\"},{\"name\":\"rel1\"}],\"meta\":[{\"id\":2,\"type\":\"node\",\"deleted\":false},{\"id\":1,\"type\":\"relationship\",\"deleted\":false}],\"graph\":{\"nodes\":[";
        int n0 = result.indexOf(node0);
        int n1 = result.indexOf(node1);
        int n2 = result.indexOf(node2);
        int n3 = result.indexOf(node3);
        int r0 = result.indexOf(rel0);
        int r1 = result.indexOf(rel1);
        int row0Index = result.indexOf(row0);
        int row1Index = result.indexOf(row1);
        Assertions.assertTrue((row0Index > 0 ? 1 : 0) != 0, (String)"result should contain row0");
        Assertions.assertTrue((row1Index > row0Index ? 1 : 0) != 0, (String)"result should contain row1 after row0");
        Assertions.assertTrue((n0 > row0Index ? 1 : 0) != 0, (String)"result should contain node0 after row0");
        Assertions.assertTrue((n1 > row0Index ? 1 : 0) != 0, (String)"result should contain node1 after row0");
        Assertions.assertTrue((n2 > row1Index ? 1 : 0) != 0, (String)"result should contain node2 after row1");
        Assertions.assertTrue((n3 > row1Index ? 1 : 0) != 0, (String)"result should contain node3 after row1");
        Assertions.assertTrue((r0 > n0 && r0 > n1 ? 1 : 0) != 0, (String)"result should contain rel0 after node0 and node1");
        Assertions.assertTrue((r1 > n2 && r1 > n3 ? 1 : 0) != 0, (String)"result should contain rel1 after node2 and node3");
    }

    @Test
    void shouldProduceResultStreamWithLegacyRestFormat() throws Exception {
        Node[] node = new Node[]{GraphMock.node((long)0L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node0")}), (String[])new String[0]), GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node1")}), (String[])new String[0]), GraphMock.node((long)2L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"node2")}), (String[])new String[0])};
        Relationship[] rel = new Relationship[]{GraphMock.relationship((long)0L, (Node)node[0], (String)"KNOWS", (Node)node[1], (Property[])new Property[]{Property.property((String)"name", (Object)"rel0")}), GraphMock.relationship((long)1L, (Node)node[2], (String)"LOVES", (Node)node[1], (Property[])new Property[]{Property.property((String)"name", (Object)"rel1")})};
        Path path = GraphMock.path((Node)node[0], (Link[])new Link[]{GraphMock.link((Relationship)rel[0], (Node)node[1]), GraphMock.link((Relationship)rel[1], (Node)node[2])});
        this.serializer = this.getSerializerWith(this.output, "http://base.uri/");
        HashMap<String, Object> resultRow = new HashMap<String, Object>();
        resultRow.put("node", node[0]);
        resultRow.put("rel", rel[0]);
        resultRow.put("path", path);
        resultRow.put("map", MapUtil.map((Object[])new Object[]{"n1", node[1], "r1", rel[1]}));
        this.writeStatementStart(Collections.singletonList(ResultDataContent.rest), "node", "rel", "path", "map");
        this.writeRecord(resultRow, "node", "rel", "path", "map");
        this.writeStatementEnd();
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        JsonNode json = JsonHelper.jsonNode((String)result);
        HashMap<String, Integer> columns = new HashMap<String, Integer>();
        int col = 0;
        JsonNode results = json.get("results").get(0);
        for (JsonNode column : results.get("columns")) {
            columns.put(column.asText(), col++);
        }
        JsonNode row = results.get("data").get(0).get("rest");
        JsonNode jsonNode = row.get(((Integer)columns.get("node")).intValue());
        JsonNode jsonRel = row.get(((Integer)columns.get("rel")).intValue());
        JsonNode jsonPath = row.get(((Integer)columns.get("path")).intValue());
        JsonNode jsonMap = row.get(((Integer)columns.get("map")).intValue());
        Assertions.assertEquals((Object)"http://base.uri/node/0", (Object)jsonNode.get("self").asText());
        Assertions.assertEquals((Object)"http://base.uri/relationship/0", (Object)jsonRel.get("self").asText());
        Assertions.assertEquals((int)2, (int)jsonPath.get("length").asInt());
        Assertions.assertEquals((Object)"http://base.uri/node/0", (Object)jsonPath.get("start").asText());
        Assertions.assertEquals((Object)"http://base.uri/node/2", (Object)jsonPath.get("end").asText());
        Assertions.assertEquals((Object)"http://base.uri/node/1", (Object)jsonMap.get("n1").get("self").asText());
        Assertions.assertEquals((Object)"http://base.uri/relationship/1", (Object)jsonMap.get("r1").get("self").asText());
    }

    @Test
    void shouldProduceResultStreamWithLegacyRestFormatAndNestedMaps() throws Exception {
        this.serializer = this.getSerializerWith(this.output, "http://base.uri/");
        HashMap<String, Object> resultRow = new HashMap<String, Object>();
        resultRow.put("map", MapUtil.map((Object[])new Object[]{"one", MapUtil.map((Object[])new Object[]{"two", Arrays.asList("wait for it...", MapUtil.map((Object[])new Object[]{"three", "GO!"}))})}));
        this.writeStatementStart(Collections.singletonList(ResultDataContent.rest), "map");
        this.writeRecord(resultRow, "map");
        this.writeStatementEnd();
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        JsonNode json = JsonHelper.jsonNode((String)result);
        HashMap<String, Integer> columns = new HashMap<String, Integer>();
        int col = 0;
        JsonNode results = json.get("results").get(0);
        for (JsonNode column : results.get("columns")) {
            columns.put(column.asText(), col++);
        }
        JsonNode row = results.get("data").get(0).get("rest");
        JsonNode jsonMap = row.get(((Integer)columns.get("map")).intValue());
        Assertions.assertEquals((Object)"wait for it...", (Object)jsonMap.get("one").get("two").get(0).asText());
        Assertions.assertEquals((Object)"GO!", (Object)jsonMap.get("one").get("two").get(1).get("three").asText());
    }

    @Test
    void shouldSerializePlanWithoutChildButAllKindsOfSupportedArguments() throws Exception {
        this.serializer = this.getSerializerWith(this.output, "http://base.uri/");
        String operatorType = "Ich habe einen Plan";
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("string", "A String");
        args.put("bool", true);
        args.put("number", 1);
        args.put("double", 2.3);
        args.put("listOfInts", Arrays.asList(1, 2, 3));
        args.put("listOfListOfInts", Arrays.asList(Arrays.asList(1, 2, 3)));
        ExecutionPlanDescription planDescription = this.mockedPlanDescription(operatorType, NO_IDS, args, NO_PLANS);
        this.writeStatementStart(Collections.singletonList(ResultDataContent.rest), new String[0]);
        this.writeRecord(Collections.emptyMap(), new String[0]);
        this.writeStatementEnd(planDescription, Collections.emptyList());
        this.writeTransactionInfo();
        String resultString = this.output.toString(StandardCharsets.UTF_8.name());
        this.assertIsPlanRoot(resultString);
        Map<String, ?> rootMap = this.planRootMap(resultString);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"operatorType", "identifiers", "children", "string", "bool", "number", "double", "listOfInts", "listOfListOfInts"}), rootMap.keySet());
        Assertions.assertEquals((Object)operatorType, rootMap.get("operatorType"));
        Assertions.assertEquals(args.get("string"), rootMap.get("string"));
        Assertions.assertEquals(args.get("bool"), rootMap.get("bool"));
        Assertions.assertEquals(args.get("number"), rootMap.get("number"));
        Assertions.assertEquals(args.get("double"), rootMap.get("double"));
        Assertions.assertEquals(args.get("listOfInts"), rootMap.get("listOfInts"));
        Assertions.assertEquals(args.get("listOfListOfInts"), rootMap.get("listOfListOfInts"));
    }

    @Test
    void shouldSerializePlanWithoutChildButWithIdentifiers() throws Exception {
        this.serializer = this.getSerializerWith(this.output, "http://base.uri/");
        String operatorType = "Ich habe einen Plan";
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        ExecutionPlanDescription planDescription = this.mockedPlanDescription(operatorType, Iterators.asSet((Object[])new String[]{id1, id2, id3}), NO_ARGS, NO_PLANS);
        this.writeStatementStart(Collections.singletonList(ResultDataContent.rest), new String[0]);
        this.writeRecord(Collections.emptyMap(), new String[0]);
        this.writeStatementEnd(planDescription, Collections.emptyList());
        this.writeTransactionInfo();
        String resultString = this.output.toString(StandardCharsets.UTF_8.name());
        this.assertIsPlanRoot(resultString);
        Map<String, ?> rootMap = this.planRootMap(resultString);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"operatorType", "identifiers", "children"}), rootMap.keySet());
        Assertions.assertEquals((Object)operatorType, rootMap.get("operatorType"));
        Assertions.assertEquals(Arrays.asList(id2, id1, id3), rootMap.get("identifiers"));
    }

    @Test
    void shouldSerializePlanWithChildren() throws Exception {
        this.serializer = this.getSerializerWith(this.output, "http://base.uri/");
        String leftId = "leftId";
        String rightId = "rightId";
        String parentId = "parentId";
        ExecutionPlanDescription left = this.mockedPlanDescription("child", Iterators.asSet((Object[])new String[]{leftId}), MapUtil.map((Object[])new Object[]{"id", 1}), NO_PLANS);
        ExecutionPlanDescription right = this.mockedPlanDescription("child", Iterators.asSet((Object[])new String[]{rightId}), MapUtil.map((Object[])new Object[]{"id", 2}), NO_PLANS);
        ExecutionPlanDescription parent = this.mockedPlanDescription("parent", Iterators.asSet((Object[])new String[]{parentId}), MapUtil.map((Object[])new Object[]{"id", 0}), Arrays.asList(left, right));
        this.writeStatementStart(Collections.singletonList(ResultDataContent.rest), new String[0]);
        this.writeRecord(Collections.emptyMap(), new String[0]);
        this.writeStatementEnd(parent, Collections.emptyList());
        this.writeTransactionInfo();
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        JsonNode root = this.assertIsPlanRoot(result);
        Assertions.assertEquals((Object)"parent", (Object)root.get("operatorType").asText());
        Assertions.assertEquals((long)0L, (long)root.get("id").asLong());
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{parentId}), this.identifiersOf(root));
        HashSet<Integer> childIds = new HashSet<Integer>();
        HashSet<Set<String>> identifiers = new HashSet<Set<String>>();
        for (JsonNode child : root.get("children")) {
            Assertions.assertTrue((boolean)child.isObject(), (String)"Expected object");
            Assertions.assertEquals((Object)"child", (Object)child.get("operatorType").asText());
            identifiers.add(this.identifiersOf(child));
            childIds.add(child.get("id").asInt());
        }
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{1, 2}), childIds);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Set[]{Iterators.asSet((Object[])new String[]{leftId}), Iterators.asSet((Object[])new String[]{rightId})}), identifiers);
    }

    @Test
    void shouldReturnNotifications() throws IOException {
        NotificationCode.Notification notification = NotificationCode.CARTESIAN_PRODUCT.notification(new InputPosition(1, 2, 3), new NotificationDetail[0]);
        List<NotificationCode.Notification> notifications = Collections.singletonList(notification);
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("column1", "value1");
        row.put("column2", "value2");
        this.writeStatementStart("column1", "column2");
        this.writeRecord(row, "column1", "column2");
        this.writeStatementEnd(null, notifications);
        this.writeTransactionInfo("commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"notifications\":[{\"code\":\"Neo.ClientNotification.Statement.CartesianProductWarning\",\"severity\":\"WARNING\",\"title\":\"This query builds a cartesian product between disconnected patterns.\",\"description\":\"If a part of a query contains multiple disconnected patterns, this will build a cartesian product between all those parts. This may produce a large amount of data and slow down query processing. While occasionally intended, it may often be possible to reformulate the query that avoids the use of this cross product, perhaps by adding a relationship between the different parts or by using OPTIONAL MATCH\",\"position\":{\"offset\":1,\"line\":2,\"column\":3}}],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldNotReturnNotificationsWhenEmptyNotifications() throws IOException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("column1", "value1");
        row.put("column2", "value2");
        this.writeStatementStart("column1", "column2");
        this.writeRecord(row, "column1", "column2");
        this.writeStatementEnd(null, Collections.emptyList());
        this.writeTransactionInfo("commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldNotReturnPositionWhenEmptyPosition() throws IOException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("column1", "value1");
        row.put("column2", "value2");
        NotificationCode.Notification notification = NotificationCode.CARTESIAN_PRODUCT.notification(InputPosition.empty, new NotificationDetail[0]);
        List<NotificationCode.Notification> notifications = Collections.singletonList(notification);
        this.writeStatementStart("column1", "column2");
        this.writeRecord(row, "column1", "column2");
        this.writeStatementEnd(null, notifications);
        this.writeTransactionInfo("commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"notifications\":[{\"code\":\"Neo.ClientNotification.Statement.CartesianProductWarning\",\"severity\":\"WARNING\",\"title\":\"This query builds a cartesian product between disconnected patterns.\",\"description\":\"If a part of a query contains multiple disconnected patterns, this will build a cartesian product between all those parts. This may produce a large amount of data and slow down query processing. While occasionally intended, it may often be possible to reformulate the query that avoids the use of this cross product, perhaps by adding a relationship between the different parts or by using OPTIONAL MATCH\"}],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    private ExecutionResultSerializer getSerializerWith(OutputStream output) {
        return this.getSerializerWith(output, null);
    }

    private ExecutionResultSerializer getSerializerWith(OutputStream output, String uri) {
        return new ExecutionResultSerializer(output, uri == null ? null : URI.create(uri), this.transactionHandle);
    }

    private void writeStatementStart(String ... columns) {
        this.writeStatementStart((List<ResultDataContent>)null, columns);
    }

    private void writeStatementStart(List<ResultDataContent> resultDataContents, String ... columns) {
        this.serializer.writeStatementStart(new StatementStartEvent(null, Arrays.asList(columns)), new InputStatement(null, null, false, resultDataContents));
    }

    private void writeRecord(Map<String, Object> row, String ... columns) {
        this.serializer.writeRecord(new RecordEvent(Arrays.asList(columns), row::get));
    }

    private void writeStatementEnd() {
        this.writeStatementEnd(null, Collections.emptyList());
    }

    private void writeStatementEnd(ExecutionPlanDescription planDescription, Iterable<Notification> notifications) {
        QueryExecutionType queryExecutionType = null != planDescription ? QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE) : QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE);
        this.serializer.writeStatementEnd(new StatementEndEvent(queryExecutionType, null, planDescription, notifications));
    }

    private void writeTransactionInfo() {
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, null, -1L));
    }

    private void writeTransactionInfo(String commitUri) {
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create(commitUri), -1L));
    }

    private void writeError(Status status, String message) {
        this.serializer.writeFailure(new FailureEvent(status, message));
    }

    private static Path mockPath(Map<String, Object> startNodeProperties, Map<String, Object> relationshipProperties, Map<String, Object> endNodeProperties) {
        Node startNode = GraphMock.node((long)1L, (Properties)Properties.properties(startNodeProperties), (String[])new String[0]);
        Node endNode = GraphMock.node((long)2L, (Properties)Properties.properties(endNodeProperties), (String[])new String[0]);
        Relationship relationship = GraphMock.relationship((long)1L, (Properties)Properties.properties(relationshipProperties), (Node)startNode, (String)"RELATED", (Node)endNode);
        return GraphMock.path((Node)startNode, (Link[])new Link[]{Link.link((Relationship)relationship, (Node)endNode)});
    }

    private Set<String> identifiersOf(JsonNode root) {
        HashSet<String> parentIds = new HashSet<String>();
        for (JsonNode id : root.get("identifiers")) {
            parentIds.add(id.asText());
        }
        return parentIds;
    }

    private ExecutionPlanDescription mockedPlanDescription(String operatorType, Set<String> identifiers, Map<String, Object> args, List<ExecutionPlanDescription> children) {
        ExecutionPlanDescription planDescription = (ExecutionPlanDescription)Mockito.mock(ExecutionPlanDescription.class);
        Mockito.when((Object)planDescription.getChildren()).thenReturn(children);
        Mockito.when((Object)planDescription.getName()).thenReturn((Object)operatorType);
        Mockito.when((Object)planDescription.getArguments()).thenReturn(args);
        Mockito.when((Object)planDescription.getIdentifiers()).thenReturn(identifiers);
        return planDescription;
    }

    private JsonNode assertIsPlanRoot(String result) throws JsonParseException {
        JsonNode json = JsonHelper.jsonNode((String)result);
        JsonNode results = json.get("results").get(0);
        JsonNode plan = results.get("plan");
        Assertions.assertTrue((plan != null && plan.isObject() ? 1 : 0) != 0, (String)"Expected plan to be an object");
        JsonNode root = plan.get("root");
        Assertions.assertTrue((root != null && root.isObject() ? 1 : 0) != 0, (String)"Expected plan to be an object");
        return root;
    }

    private Map<String, ?> planRootMap(String resultString) throws JsonParseException {
        Map resultMap = (Map)((List)((Map)JsonHelper.readJson((String)resultString)).get("results")).get(0);
        Map planMap = (Map)resultMap.get("plan");
        return (Map)planMap.get("root");
    }
}

