/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.http.cypher.integration.TransactionMatchers;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

public class RowFormatMetaFieldTestIT
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri(RowFormatMetaFieldTestIT.server().baseUri());
    private String commitResource;

    @Before
    public void setUp() {
        HTTP.Response begin = this.http.POST(RowFormatMetaFieldTestIT.txUri());
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        RowFormatMetaFieldTestIT.assertHasTxLocation(begin);
        try {
            this.commitResource = begin.stringFromContent("commit");
        }
        catch (JsonParseException e) {
            Assert.fail((String)("Exception caught when setting up test: " + e.getMessage()));
        }
        MatcherAssert.assertThat((Object)this.commitResource, (Matcher)CoreMatchers.equalTo((Object)(begin.location() + "/commit")));
    }

    @After
    public void tearDown() {
        this.executeTransactionally("MATCH (n) DETACH DELETE n");
    }

    @Test
    public void metaFieldShouldGetCorrectIndex() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (s:Start)-[r:R]->(e:End) RETURN s, r, 1, e"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsMetaNodesAtIndex(0, 3));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsMetaRelsAtIndex(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void metaFieldShouldGivePathInfoInList() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsAMetaListAtIndex(0));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void metaFieldShouldPutPathListAtCorrectIndex() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) RETURN 10, p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsAMetaListAtIndex(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    private void executeTransactionally(String query) {
        GraphDatabaseService database = this.graphdb();
        try (Transaction transaction = database.beginTx();){
            transaction.execute(query);
            transaction.commit();
        }
    }

    private HTTP.RawPayload queryAsJsonRow(String query) {
        return HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'row' ] } ] }");
    }
}

